/**
 * Copyright (c) 2016 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * SPDX-License-Identifier: EPL-2.0
 * Contributors:
 * Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine;

import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Type;

@SuppressWarnings("all")
public class CompleteStatemachine implements IM2MTrafoElem {
  public static final String THREAD_FUNCTIONS = "ThreadFunctions";

  public static final String SYSTEM_STATE_ENUM_T = "SystemStateEnum_t";

  public static final String STRUCT_FOR_THREAD = "StructForThread_t";

  public static final String STATE_T = "State_t";

  public static final String EVENT_T = "Event_t";

  public static final URI SM_JAVA_URI = URI.createURI("pathmap://DML_TRAFOS_JAVA/statemachineJava.uml");

  @Override
  public void transformElement(final M2MTrafo trafo, final Element element) {
    if ((element instanceof org.eclipse.uml2.uml.Class)) {
      org.eclipse.uml2.uml.Class tmClass = ((org.eclipse.uml2.uml.Class) element);
      Behavior _classifierBehavior = tmClass.getClassifierBehavior();
      if ((_classifierBehavior instanceof StateMachine)) {
        Behavior _classifierBehavior_1 = tmClass.getClassifierBehavior();
        StateMachine sm = ((StateMachine) _classifierBehavior_1);
        LazyCopier copier = TransformationContext.current.copier;
        SM2ClassesTransformationCore trafoCore = new SM2ClassesTransformationCore(copier, sm, tmClass);
        final org.eclipse.uml2.uml.Package smModel = ElementUtils.loadPackage(CompleteStatemachine.SM_JAVA_URI, ModelManagement.getResourceSet());
        NamedElement stateEnum = smModel.getPackagedElement(CompleteStatemachine.SYSTEM_STATE_ENUM_T);
        NamedElement threadFuncEnum = smModel.getPackagedElement(CompleteStatemachine.THREAD_FUNCTIONS);
        PackageableElement _packagedElement = smModel.getPackagedElement(CompleteStatemachine.STRUCT_FOR_THREAD);
        Type structForThread = ((Type) _packagedElement);
        PackageableElement _packagedElement_1 = smModel.getPackagedElement(CompleteStatemachine.STATE_T);
        Type state_t = ((Type) _packagedElement_1);
        PackageableElement _packagedElement_2 = smModel.getPackagedElement(CompleteStatemachine.EVENT_T);
        Type event_t = ((Type) _packagedElement_2);
        trafoCore.setThreadStructType(structForThread);
        trafoCore.setState_t(state_t);
        trafoCore.setEvent_t(event_t);
        trafoCore.setSmPack(smModel);
        tmClass.createOwnedAttribute(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, ((Type) stateEnum));
        tmClass.createDependency(threadFuncEnum);
        trafoCore.threadFuncEnum = ((Type) threadFuncEnum);
        trafoCore.transform();
      }
    }
  }
}
