/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.realtime.pycpa.m2t.executors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.engine.utils.AcceleoLaunchingUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.designer.realtime.pycpa.m2t.batch.GenerateAnalysis;
import org.osgi.framework.Bundle;

public class PyCPAModelToPythonCodeTransformExecutor {
    private URI modelURI;
    private IContainer targetFolder;
    List<? extends Object> arguments;

    public PyCPAModelToPythonCodeTransformExecutor(URI modelURI, IContainer targetFolder, List<? extends Object> arguments) {
        this.modelURI = modelURI;
        this.targetFolder = targetFolder;
        this.arguments = arguments;
    }

    public void doGenerate(IProgressMonitor monitor) throws IOException {
        if (!this.targetFolder.getLocation().toFile().exists()) {
            this.targetFolder.getLocation().toFile().mkdirs();
        }
        if (monitor != null) {
            monitor.subTask("Loading...");
        }
        GenerateAnalysis gen0 = new GenerateAnalysis(this.modelURI, this.targetFolder.getLocation().toFile(), this.arguments);
        if (monitor != null) {
            monitor.worked(1);
        }
        String generationID = AcceleoLaunchingUtil.computeUIProjectID((String)"org.eclipse.papyrus.designer.realtime.pycpa.m2t", (String)"org.eclipse.papyrus.designer.realtime.pycpa.m2t.batch.GenerateAnalysis", (String)this.modelURI.toString(), (String)this.targetFolder.getFullPath().toString(), new ArrayList());
        gen0.setGenerationID(generationID);
        if (monitor != null) {
            gen0.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
        } else {
            gen0.doGenerate(null);
        }
        IFile rtmlAnalysisScript = this.targetFolder.getFile((IPath)new Path("pycpa_analysis.py"));
        if (!rtmlAnalysisScript.exists()) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.papyrus.designer.realtime.pycpa.m2t");
            URL fileURL = bundle.getEntry("python/pycpa_analysis.py");
            File bundleAnalysisScript = null;
            try {
                bundleAnalysisScript = new File(FileLocator.resolve((URL)fileURL).toURI());
                byte[] bytes = PyCPAModelToPythonCodeTransformExecutor.readFileToByteArray(bundleAnalysisScript);
                ByteArrayInputStream source = new ByteArrayInputStream(bytes);
                rtmlAnalysisScript.create((InputStream)source, 0, null);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private static byte[] readFileToByteArray(File file) {
        FileInputStream fis = null;
        byte[] bArray = new byte[(int)file.length()];
        try {
            fis = new FileInputStream(file);
            fis.read(bArray);
            fis.close();
        }
        catch (IOException ioExp) {
            ioExp.printStackTrace();
        }
        return bArray;
    }
}

