/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ExternLibrary;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Visibility;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.ConnectableElementTemplateParameter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OperationTemplateParameter;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CppGenUtils {
    public static final String ANSI_C_LIB = "AnsiCLibrary";
    public static final Pattern EmptySectionRegex = Pattern.compile("^\\s*$");
    public static boolean USE_ALL_NS = true;
    private Context context = new Context();
    private static CppGenUtils lastGenUtils = null;

    protected CppGenUtils(Namespace ns) {
        this.context.ns = ns;
    }

    public static CppGenUtils cgu(Element element) {
        while (true) {
            if (element instanceof Classifier || element instanceof Package) {
                if (!(element instanceof Behavior)) {
                    return CppGenUtils.cguFromNS((Namespace)element);
                }
            } else if (element == null) break;
            element = element.getOwner();
        }
        return null;
    }

    public static CppGenUtils cguFromNS(Namespace ns) {
        if (lastGenUtils == null || CppGenUtils.lastGenUtils.context.ns != ns) {
            lastGenUtils = new CppGenUtils(ns);
        }
        return lastGenUtils;
    }

    public static String getTemplateParametersWoType(Classifier classifier) {
        Object tparamWoType = "";
        Iterator it = GenUtils.getTemplateParameters((Classifier)classifier).iterator();
        while (it.hasNext()) {
            TemplateParameter currentTParam = (TemplateParameter)it.next();
            tparamWoType = (String)tparamWoType + GenUtils.getTemplateName((TemplateParameter)currentTParam);
            if (!it.hasNext()) continue;
            tparamWoType = (String)tparamWoType + ", ";
        }
        return tparamWoType;
    }

    public static String getStdtypes(PrimitiveType type) {
        Element owner = type.getOwner();
        String owningPkgName = "";
        if (owner instanceof Package) {
            owningPkgName = ((Package)owner).getName();
        }
        if (owningPkgName.equals("PrimitiveTypes") || owningPkgName.equals("UMLPrimitiveTypes") || owningPkgName.equals("MARTE_PrimitivesTypes")) {
            String td = null;
            String name = type.getName();
            if (name.equals("Boolean")) {
                td = "bool";
            } else if (name.equals("Integer")) {
                td = "int";
            } else if (name.equals("Unlimited Natural")) {
                td = "unsigned long";
            } else if (name.equals("Real")) {
                td = "float";
            } else if (name.equals("String")) {
                td = "const char *";
            } else if (name.equals("Unlimited Natural")) {
                td = "unsigned long";
            }
            if (td != null) {
                return String.format("typedef %s %s;", td, name);
            }
        }
        return "";
    }

    public static String transformCORBABaseTypes(PrimitiveType type) {
        Element owner = type.getOwner();
        String owningPkgName = "";
        if (owner instanceof Package) {
            owningPkgName = ((Package)owner).getName();
        }
        if (owningPkgName.equals("CORBA")) {
            Object cppName = "CORBA::";
            boolean nextUpper = true;
            char[] cArray = type.getName().toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                if (ch == ' ') {
                    nextUpper = true;
                } else {
                    cppName = nextUpper ? (String)cppName + Character.toUpperCase(ch) : (String)cppName + ch;
                    nextUpper = false;
                }
                ++n2;
            }
            return cppName;
        }
        return null;
    }

    public String cppQualifiedName(NamedElement ne) {
        String cppType;
        if (ne == null) {
            return "undefined";
        }
        Element owner = ne.getOwner();
        String owningPkgName = "";
        if (owner instanceof Package) {
            owningPkgName = ((Package)owner).getName();
        }
        if (ne instanceof PrimitiveType && (cppType = CppGenUtils.transformCORBABaseTypes((PrimitiveType)ne)) != null) {
            return cppType;
        }
        if (GenUtils.hasStereotypeTree((Element)ne, NoCodeGen.class)) {
            return ne.getName();
        }
        if (GenUtils.hasStereotypeTree((Element)ne, ExternLibrary.class)) {
            ExternLibrary extLibrary = (ExternLibrary)GenUtils.getApplicationTree((Element)ne, ExternLibrary.class);
            return GenUtils.maskNull((String)extLibrary.getPrefix()) + ne.getName();
        }
        if (GenUtils.hasStereotype((Element)ne, org.eclipse.papyrus.designer.languages.common.profile.Codegen.External.class)) {
            org.eclipse.papyrus.designer.languages.common.profile.Codegen.External extCpp = (org.eclipse.papyrus.designer.languages.common.profile.Codegen.External)UMLUtil.getStereotypeApplication((Element)ne, External.class);
            org.eclipse.papyrus.designer.languages.common.profile.Codegen.External extCommon = (org.eclipse.papyrus.designer.languages.common.profile.Codegen.External)UMLUtil.getStereotypeApplication((Element)ne, External.class);
            if (extCpp != null && extCpp.getName() != null && extCpp.getName().length() > 0) {
                return extCpp.getName();
            }
            if (extCommon != null && extCommon.getName() != null && extCommon.getName().length() > 0) {
                return extCommon.getName();
            }
            return ne.getName();
        }
        if (owningPkgName.equals(ANSI_C_LIB)) {
            return ne.getName();
        }
        if (owner instanceof ClassifierTemplateParameter) {
            return ne.getName();
        }
        Object qName = ne.getName();
        if (this.context.ns.getNamespace() == ne.getNamespace()) {
            return qName;
        }
        if (ne instanceof PrimitiveType && !GenUtils.hasStereotype((Element)ne, Typedef.class) && CppGenUtils.getStdtypes((PrimitiveType)ne).length() == 0) {
            return qName;
        }
        if (CppCodeGenUtils.getUsingNamespaces() && this.context.ns instanceof Classifier && this.context.usingClasses != null && this.context.usingClasses.contains(ne)) {
            return qName;
        }
        for (Namespace ns : ne.allNamespaces()) {
            if (ns.getOwner() == null && !USE_ALL_NS) continue;
            qName = ns.getName() + "::" + (String)qName;
        }
        if (qName == null) {
            GenUtils.checkProxy((EObject)ne);
            return "undefined";
        }
        if (((String)qName).contains("::")) {
            return "::" + (String)qName;
        }
        return qName;
    }

    public static String getTemplateTypeName(TemplateParameter templateParam) {
        Object prefix = "";
        String name = "";
        ParameterableElement pElt = templateParam.getParameteredElement();
        if (pElt != null && pElt instanceof NamedElement) {
            name = ((NamedElement)pElt).getName();
            if (templateParam instanceof ClassifierTemplateParameter) {
                prefix = "class ";
            } else if (!(templateParam instanceof OperationTemplateParameter) && !(templateParam instanceof ConnectableElementTemplateParameter)) {
                prefix = pElt instanceof LiteralInteger ? "int " : (pElt instanceof LiteralString ? "String " : (pElt instanceof LiteralBoolean ? "Boolean " : (pElt instanceof LiteralUnlimitedNatural ? "UnlimitedNatural " : pElt.eClass().getName() + " ")));
            }
        } else {
            name = "undefined";
        }
        return (String)prefix + name;
    }

    public static String getNamespace(NamedElement ne) {
        Object namespace = "";
        for (Namespace ns : ne.allNamespaces()) {
            if (ns.getOwner() == null) continue;
            Object nsName = ns.getName();
            if (!((String)namespace).equals("")) {
                nsName = (String)nsName + "::";
            }
            namespace = (String)nsName + (String)namespace;
        }
        if (!((String)namespace).equals("")) {
            namespace = "\nusing namespace " + (String)namespace + ";\n";
        }
        return namespace;
    }

    public static EList<Namespace> getAllNamespaces(NamedElement ne) {
        if (ne instanceof Package) {
            BasicEList allNamespaces = new BasicEList();
            allNamespaces.add((Object)((Package)ne));
            allNamespaces.addAll((Collection)ne.allNamespaces());
            return allNamespaces;
        }
        return ne.allNamespaces();
    }

    public static String openNS(NamedElement ne) {
        Object openNS = "";
        for (Namespace ns : CppGenUtils.getAllNamespaces(ne)) {
            if (ns.getOwner() == null && !USE_ALL_NS) continue;
            openNS = "namespace " + ns.getName() + " {\n" + (String)openNS;
        }
        return openNS;
    }

    public static String openNSMinimal(NamedElement ne) {
        Object openNS = "";
        for (Namespace ns : CppGenUtils.getAllNamespaces(ne)) {
            if (ns.getOwner() == null && !USE_ALL_NS) continue;
            openNS = "namespace " + ns.getName() + " {" + (String)openNS;
        }
        return openNS;
    }

    public static String closeNS(NamedElement ne) {
        Object closeNS = "";
        for (Namespace ns : CppGenUtils.getAllNamespaces(ne)) {
            if (ns.getOwner() == null && !USE_ALL_NS) continue;
            closeNS = (String)closeNS + "} // of namespace " + ns.getName() + "\n";
        }
        return closeNS;
    }

    public static String closeNSMinimal(NamedElement ne) {
        Object closeNS = "";
        for (Namespace ns : CppGenUtils.getAllNamespaces(ne)) {
            if (ns.getOwner() == null && !USE_ALL_NS) continue;
            closeNS = (String)closeNS + "}";
        }
        return closeNS;
    }

    public static String getGeneralizationVisibility(Element element) {
        Visibility cppVisibility = (Visibility)UMLUtil.getStereotypeApplication((Element)element, Visibility.class);
        if (cppVisibility != null) {
            return cppVisibility.getValue();
        }
        return "public";
    }

    public void resetVisibility(VisibilityKind v) {
        this.context.visibility = v;
    }

    public void setUsing(List<Classifier> usingClasses) {
        this.context.usingClasses = usingClasses;
    }

    public VisibilityKind getCurrentVisibility() {
        return this.context.visibility;
    }

    public String getSection(VisibilityKind visibility, String content) {
        VisibilityKind newVisibility = null;
        if (!visibility.equals((Object)this.context.visibility)) {
            newVisibility = visibility;
        }
        Matcher m = EmptySectionRegex.matcher(content);
        if (content.isEmpty() || m.matches()) {
            return "";
        }
        if (newVisibility == null) {
            return content;
        }
        this.context.visibility = newVisibility;
        return this.context.visibility.toString() + ":\n" + content;
    }

    class Context {
        public Namespace ns;
        public List<Classifier> usingClasses = null;
        public VisibilityKind visibility = null;

        Context() {
        }
    }
}

