/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.module;

import com.google.common.collect.Iterables;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.ClassScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.CommonScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.FunctionScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.ImportScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.variableScript;
import org.eclipse.papyrus.designer.languages.c.codegen.services.UmlCommentServices;
import org.eclipse.papyrus.designer.uml.tools.utils.StateMachineUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ClassModuleScript {
  public static CharSequence classModuleScript(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    CharSequence _genHeading = CommonScript.genHeading(clazz);
    _builder.append(_genHeading, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _genBodyIncludes = ImportScript.genBodyIncludes(clazz);
    _builder.append(_genBodyIncludes);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _genModuleDeclarationBody = ClassModuleScript.genModuleDeclarationBody(clazz);
    _builder.append(_genModuleDeclarationBody);
    _builder.newLineIfNotEmpty();
    CharSequence _genModuleImplementationBody = ClassModuleScript.genModuleImplementationBody(clazz);
    _builder.append(_genModuleImplementationBody);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * Generate the declaration for the body. This includes only private and protected functions
   * (the header file contains only the public declarations)
   */
  public static CharSequence genModuleDeclarationBody(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      VisibilityKind _visibility = clazz.getVisibility();
      boolean _notEquals = (!Objects.equals(_visibility, VisibilityKind.PUBLIC_LITERAL));
      if (_notEquals) {
        String _partComment = UmlCommentServices.partComment(clazz, "Private Class Description");
        _builder.append(_partComment);
        _builder.newLineIfNotEmpty();
        _builder.append("// Structure ");
        _builder.newLine();
        CharSequence _genClassStructDeclarations = ClassScript.genClassStructDeclarations(clazz);
        _builder.append(_genClassStructDeclarations);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// Constructor and destructor declarations ");
        _builder.newLine();
        CharSequence _genDynamicInstanciationOperationPrototypes = ClassScript.genDynamicInstanciationOperationPrototypes(clazz);
        _builder.append(_genDynamicInstanciationOperationPrototypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// Property initialization declarations");
        _builder.newLine();
        CharSequence _genDefaultInitialisationProtoype = ClassScript.genDefaultInitialisationProtoype(clazz);
        _builder.append(_genDefaultInitialisationProtoype);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// Class method declarations");
        _builder.newLine();
        CharSequence _genNonStaticFunctionDeclarations = ClassScript.genNonStaticFunctionDeclarations(clazz);
        _builder.append(_genNonStaticFunctionDeclarations);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      final Function1<Property, Boolean> _function = (Property it) -> {
        return Boolean.valueOf(((it.isStatic() && (!Objects.equals(it.getVisibility(), VisibilityKind.PUBLIC_LITERAL))) && (it.getType() != null)));
      };
      int _size = IterableExtensions.size(IterableExtensions.<Property>filter(clazz.getOwnedAttributes(), _function));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        String _partComment_1 = UmlCommentServices.partComment(clazz, "private/protected global variable declarations");
        _builder.append(_partComment_1);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<Property> _ownedAttributes = clazz.getOwnedAttributes();
      for(final Property attribute : _ownedAttributes) {
        {
          if (((attribute.isStatic() && (!Objects.equals(attribute.getVisibility(), VisibilityKind.PUBLIC_LITERAL))) && (attribute.getType() != null))) {
            _builder.append("// global variable declaration");
            _builder.newLine();
            CharSequence _genVariableDeclaration = variableScript.genVariableDeclaration(attribute);
            _builder.append(_genVariableDeclaration);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    {
      final Function1<Operation, Boolean> _function_1 = (Operation it) -> {
        return Boolean.valueOf((((!it.isStatic()) && Objects.equals(it.getNamespace().getVisibility(), VisibilityKind.PUBLIC_LITERAL)) && (!Objects.equals(it.getVisibility(), VisibilityKind.PUBLIC_LITERAL))));
      };
      int _size_1 = IterableExtensions.size(IterableExtensions.<Operation>filter(clazz.getOwnedOperations(), _function_1));
      boolean _greaterThan_1 = (_size_1 > 0);
      if (_greaterThan_1) {
        String _partComment_2 = UmlCommentServices.partComment(clazz, "Private/protected function declarations");
        _builder.append(_partComment_2);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<Operation> _ownedOperations = clazz.getOwnedOperations();
      for(final Operation operation : _ownedOperations) {
        {
          if ((((!operation.isStatic()) && Objects.equals(operation.getNamespace().getVisibility(), VisibilityKind.PUBLIC_LITERAL)) && (!Objects.equals(operation.getVisibility(), VisibilityKind.PUBLIC_LITERAL)))) {
            CharSequence _genFunctionPrototype = FunctionScript.genFunctionPrototype(operation);
            _builder.append(_genFunctionPrototype);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    {
      final Function1<Operation, Boolean> _function_2 = (Operation it) -> {
        return Boolean.valueOf((it.isStatic() && (!Objects.equals(it.getVisibility(), VisibilityKind.PUBLIC_LITERAL))));
      };
      int _size_2 = IterableExtensions.size(IterableExtensions.<Operation>filter(clazz.getAllOperations(), _function_2));
      boolean _greaterThan_2 = (_size_2 > 0);
      if (_greaterThan_2) {
        String _partComment_3 = UmlCommentServices.partComment(clazz, "Private/Protected global (static) function declarations");
        _builder.append(_partComment_3);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<Operation> _allOperations = clazz.getAllOperations();
      for(final Operation operation_1 : _allOperations) {
        {
          if ((operation_1.isStatic() && (!Objects.equals(operation_1.getVisibility(), VisibilityKind.PUBLIC_LITERAL)))) {
            CharSequence _genFunctionPrototype_1 = FunctionScript.genFunctionPrototype(operation_1);
            _builder.append(_genFunctionPrototype_1);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  public static CharSequence genModuleImplementationBody(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _genDynamicInstanciationOperations = ClassScript.genDynamicInstanciationOperations(clazz);
    _builder.append(_genDynamicInstanciationOperations);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _genDefaultIntialisationOperation = ClassScript.genDefaultIntialisationOperation(clazz);
    _builder.append(_genDefaultIntialisationOperation);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      EList<Operation> _operations = clazz.getOperations();
      for(final Operation operation : _operations) {
        CharSequence _genFunctionImplementation = FunctionScript.genFunctionImplementation(operation);
        _builder.append(_genFunctionImplementation);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      EList<Reception> _ownedReceptions = clazz.getOwnedReceptions();
      for(final Reception reception : _ownedReceptions) {
        {
          Signal _signal = reception.getSignal();
          boolean _tripleNotEquals = (_signal != null);
          if (_tripleNotEquals) {
            CharSequence _genFunctionImplementation_1 = FunctionScript.genFunctionImplementation(reception);
            _builder.append(_genFunctionImplementation_1);
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      Behavior _classifierBehavior = clazz.getClassifierBehavior();
      boolean _tripleNotEquals_1 = (_classifierBehavior != null);
      if (_tripleNotEquals_1) {
        {
          Iterable<SignalEvent> _filter = Iterables.<SignalEvent>filter(clazz.getModel().allOwnedElements(), SignalEvent.class);
          for(final SignalEvent signalEvent : _filter) {
            CharSequence _genSignalEventProcessFunctionImplementation = FunctionScript.genSignalEventProcessFunctionImplementation(signalEvent, clazz);
            _builder.append(_genSignalEventProcessFunctionImplementation);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    {
      Behavior _classifierBehavior_1 = clazz.getClassifierBehavior();
      boolean _tripleNotEquals_2 = (_classifierBehavior_1 != null);
      if (_tripleNotEquals_2) {
        {
          Iterable<CallEvent> _filter_1 = Iterables.<CallEvent>filter(clazz.getModel().allOwnedElements(), CallEvent.class);
          for(final CallEvent callevent : _filter_1) {
            {
              if (((callevent.getOperation() != null) && clazz.getOperations().contains(callevent.getOperation()))) {
                CharSequence _genCallEventProcessFunctionImplementation = FunctionScript.genCallEventProcessFunctionImplementation(callevent, clazz);
                _builder.append(_genCallEventProcessFunctionImplementation);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    _builder.newLine();
    {
      if (((clazz.getClassifierBehavior() != null) && (!IterableExtensions.isEmpty(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class))))) {
        StateMachine sm = IterableExtensions.<StateMachine>head(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class));
        _builder.newLineIfNotEmpty();
        {
          final Function1<State, Boolean> _function = (State it) -> {
            return Boolean.valueOf((!(it instanceof FinalState)));
          };
          boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(sm.getRegions()).getSubvertices(), State.class), _function));
          boolean _not = (!_isEmpty);
          if (_not) {
            final Function1<State, Boolean> _function_1 = (State it) -> {
              return Boolean.valueOf((!(it instanceof FinalState)));
            };
            Iterable<State> states = IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(IterableExtensions.<StateMachine>head(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class)).getRegions()).getSubvertices(), State.class), _function_1);
            _builder.newLineIfNotEmpty();
            {
              for(final State state : states) {
                {
                  boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist(state.getEntry());
                  if (_isBehaviorExist) {
                    _builder.append("\t\t");
                    String _genEntryImplementation = FunctionScript.genEntryImplementation(state);
                    _builder.append(_genEntryImplementation, "\t\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
                {
                  boolean _isBehaviorExist_1 = StateMachineUtils.isBehaviorExist(state.getExit());
                  if (_isBehaviorExist_1) {
                    _builder.append("\t\t");
                    String _genExitImplementation = FunctionScript.genExitImplementation(state);
                    _builder.append(_genExitImplementation, "\t\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
                {
                  boolean _isBehaviorExist_2 = StateMachineUtils.isBehaviorExist(state.getDoActivity());
                  if (_isBehaviorExist_2) {
                    _builder.append("\t\t");
                    String _genDoActivityImplementation = FunctionScript.genDoActivityImplementation(state);
                    _builder.append(_genDoActivityImplementation, "\t\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
            _builder.append("\t\t\t\t");
            _builder.newLine();
          }
        }
        {
          boolean _hasTriggerlessTransition = StateMachineUtils.hasTriggerlessTransition(sm);
          if (_hasTriggerlessTransition) {
            CharSequence _genProcessCompletionEventFunctionImplementation = FunctionScript.genProcessCompletionEventFunctionImplementation(clazz);
            _builder.append(_genProcessCompletionEventFunctionImplementation);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
}
