/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.vsl;

import org.eclipse.papyrus.MARTE.utils.MarteUtils;
import org.eclipse.papyrus.MARTE_Library.MeasurementUnits.DataSizeUnitKind;
import org.eclipse.papyrus.MARTE_Library.MeasurementUnits.FrequencyUnitKind;
import org.eclipse.papyrus.MARTE_Library.MeasurementUnits.TimeUnitKind;
import org.eclipse.papyrus.designer.transformation.vsl.Messages;

public class ParseVSL {
    private static final String UNIT = "unit";
    private static final String VALUE = "value";

    public static int getSizeFromVSL(String nfpDatasize) {
        if (nfpDatasize != null) {
            String unit = MarteUtils.getValueFromTuple((String)nfpDatasize, (String)UNIT);
            String value = MarteUtils.getValueFromTuple((String)nfpDatasize, (String)VALUE);
            return Float.valueOf(value).intValue() * ParseVSL.getMultiplicatorFromSizeUnit(unit);
        }
        return 0;
    }

    public static long getDurationFromVSL(String nfpDuration) {
        if (nfpDuration != null) {
            String unit = MarteUtils.getValueFromTuple((String)nfpDuration, (String)UNIT);
            String value = MarteUtils.getValueFromTuple((String)nfpDuration, (String)VALUE);
            return (long)Float.valueOf(value).intValue() * ParseVSL.getMultiplicatorFromTimeUnit(unit);
        }
        return 0L;
    }

    public static long getMsDurationFromVSL(String nfpDuration) {
        return ParseVSL.getDurationFromVSL(nfpDuration) / 1000L;
    }

    public static long getFrequencyFromVSL(String nfpFrequency) {
        if (nfpFrequency != null) {
            String unit = MarteUtils.getValueFromTuple((String)nfpFrequency, (String)UNIT);
            String value = MarteUtils.getValueFromTuple((String)nfpFrequency, (String)VALUE);
            return (int)(Float.valueOf(value).floatValue() * ParseVSL.getMultiplicatorFromFrequencyUnit(unit));
        }
        return 0L;
    }

    public static long getPeriodFromArrivalPattern(String arrivalPattern) {
        if (arrivalPattern != null) {
            String period = MarteUtils.getValueFromTuple((String)arrivalPattern, (String)"period");
            return ParseVSL.getDurationFromVSL(period);
        }
        return 0L;
    }

    public static int getMultiplicatorFromSizeUnit(String unit) {
        DataSizeUnitKind dsuk = DataSizeUnitKind.get((String)unit);
        if (dsuk == DataSizeUnitKind.BYTE) {
            return 1;
        }
        if (dsuk == DataSizeUnitKind.KB) {
            return 1024;
        }
        if (dsuk == DataSizeUnitKind.MB) {
            return 0x100000;
        }
        if (dsuk == DataSizeUnitKind.GB) {
            return 0x40000000;
        }
        throw new RuntimeException(String.format(Messages.ParseVSL_ErrorInExp_SIZE, unit));
    }

    public static long getMultiplicatorFromTimeUnit(String unit) {
        TimeUnitKind tuk = TimeUnitKind.get((String)unit);
        if (tuk == TimeUnitKind.US) {
            return 1L;
        }
        if (tuk == TimeUnitKind.MS) {
            return 1000L;
        }
        if (tuk == TimeUnitKind.S) {
            return 1000000L;
        }
        if (tuk == TimeUnitKind.MIN) {
            return 60000000L;
        }
        throw new RuntimeException(String.format(Messages.ParseVSL_ErrorInExp_TIME, unit));
    }

    public static float getMultiplicatorFromFrequencyUnit(String unit) {
        FrequencyUnitKind fuk = FrequencyUnitKind.get((String)unit);
        if (fuk == FrequencyUnitKind.HZ) {
            return 1.0f;
        }
        if (fuk == FrequencyUnitKind.KHZ) {
            return 1000.0f;
        }
        if (fuk == FrequencyUnitKind.MHZ) {
            return 1000000.0f;
        }
        if (fuk == FrequencyUnitKind.GHZ) {
            return 1.0E9f;
        }
        if (fuk == FrequencyUnitKind.RPM) {
            return 0.0f;
        }
        throw new RuntimeException(String.format(Messages.ParseVSL_ErrotInExp_FREQ, unit));
    }
}

