/**
 * Copyright (c) 2022 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.papyrus.designer.transformation.library.xtend;

import org.eclipse.uml2.uml.Operation;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class MultipleReceptacle {
  public CharSequence operation_(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("for (int i=0; i&lt;9; i++) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (rconn[i] != 0) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("rconn[i]->");
    CharSequence _cppCall = CppUtils.cppCall(operation);
    _builder.append(_cppCall, "\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
