/**
 * Copyright (c) 2022, 2023 CEA LIST
 * 
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Mohamed Harkat - Initial API and implementation
 *   Ansgar Radermacher - Integration and bug fixes
 */
package org.eclipse.papyrus.designer.languages.python.codegen.gen;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class PyDatatype {
  public static CharSequence genDatatype(final DataType datatype) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("class ");
    String _name = datatype.getName();
    _builder.append(_name);
    _builder.append(":");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("def __init__(self):");
    _builder.newLine();
    {
      boolean _isEmpty = datatype.getAllAttributes().isEmpty();
      if (_isEmpty) {
        _builder.append("\t\t");
        _builder.append("pass");
        _builder.newLine();
      } else {
        {
          EList<Property> _allAttributes = datatype.getAllAttributes();
          for(final Property att : _allAttributes) {
            _builder.append("\t\t");
            _builder.append("self.");
            String _name_1 = att.getName();
            _builder.append(_name_1, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    return _builder;
  }
}
