/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.transformations;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.InitPrecedence;
import org.eclipse.papyrus.designer.deployment.tools.AllocUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.common.base.StringUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.library.Messages;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class AbstractBootLoaderGen
implements IM2MTrafoCDP {
    protected static final String CREATE_CONNECTIONS = "createConnections";
    protected static final String SYSINTERFACES_ISTART = "sysinterfaces::IStart";
    protected static final String INIT_OP = "init";
    protected static final String I_LIFE_CYCLE = "ILifeCycle";
    protected static final String EMPTYSTR = "";
    protected static final String NODE_INFO = "NodeInfo";
    protected static final String NL = "\n";
    protected static final String EOL = ";\n";
    protected Class m_bootLoader;
    protected String m_initCode;
    protected String m_initCodeCConfig;
    protected String m_initCodeCConnections;
    protected String m_initCodeRun;
    protected Map<Class, EList<String>> m_activation;
    protected boolean outputSizeof;
    protected LazyCopier m_copier;

    public abstract void languageInit();

    public abstract String languageActivation(Class[] var1);

    public abstract String languageDeactivation(Class[] var1);

    public abstract String languageDefaultExecCode();

    public abstract String languageCreateInstance(InstanceSpecification var1, Class var2);

    public abstract String languageCreateConn(String var1);

    public abstract String languageRunStart(String var1, boolean var2);

    public abstract String languageAssignRef(String var1, String var2);

    public void init(LazyCopier copier, int nodeIndex, int numberOfNodes) throws TransformationException {
        this.outputSizeof = false;
        this.m_copier = copier;
        this.m_initCode = EMPTYSTR;
        this.m_initCodeRun = EMPTYSTR;
        this.m_activation = new LinkedHashMap<Class, EList<String>>();
        this.m_initCodeCConnections = EMPTYSTR;
        this.m_initCodeCConfig = EMPTYSTR;
    }

    public String getPath(Stack<Slot> slotPath, InstanceSpecification instance, boolean accessName) {
        if (slotPath.size() > 0) {
            String path = ((Slot)slotPath.get(0)).getOwningInstance().getName();
            boolean previousInstantiatedByBL = false;
            for (Slot pathElement : slotPath) {
                if (pathElement == null) continue;
                if (previousInstantiatedByBL && accessName) {
                    path = StringUtils.varName((String)path);
                }
                path = String.valueOf(path) + "." + pathElement.getDefiningFeature().getName();
                previousInstantiatedByBL = this.instantiateViaBootloader(pathElement.getDefiningFeature());
            }
            if (previousInstantiatedByBL && !accessName) {
                path = StringUtils.varName((String)path);
            }
            return path;
        }
        return instance.getName();
    }

    public static boolean hasUnconnectedStartRoutine(Class implementation, Slot containerSlot) {
        Port startPort = AllocUtils.getStartPort((Class)implementation);
        if (startPort != null) {
            return !AbstractBootLoaderGen.isConnected(containerSlot, startPort);
        }
        return false;
    }

    public boolean implementsIStart(Class implementation) {
        Port startPort = AllocUtils.getStartPort((Class)implementation);
        if (startPort == null) {
            for (InterfaceRealization ir : implementation.getInterfaceRealizations()) {
                if (!ir.getContract().getQualifiedName().equals(SYSINTERFACES_ISTART)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasUnconnectedLifeCycle(Class implementation, Slot containerSlot) {
        Port lcPort;
        NamedElement lcPortElem;
        if (implementation != null && (lcPortElem = ElementUtils.getNamedElementFromList((EList)implementation.getAllAttributes(), (String)"lc")) instanceof Port && (lcPort = (Port)lcPortElem).getType().getName().equals(I_LIFE_CYCLE)) {
            return !AbstractBootLoaderGen.isConnected(containerSlot, lcPort);
        }
        return false;
    }

    private static boolean isConnected(Slot containerSlot, Port port) {
        StructuralFeature sf;
        if (containerSlot != null && (sf = containerSlot.getDefiningFeature()) instanceof Property) {
            Property part = (Property)sf;
            Class composite = part.getClass_();
            for (Connector connector : composite.getOwnedConnectors()) {
                ConnectorEnd end = ConnectorUtil.connEndForPart((Connector)connector, (Property)part);
                if (end == null || end.getRole() != port) continue;
                return true;
            }
        }
        return false;
    }

    public void instanceConfig(Stack<Slot> slotPath, InstanceSpecification instance) throws TransformationException {
        Slot slot = slotPath.peek();
        StructuralFeature sf = slot.getDefiningFeature();
        if (sf == null) {
            throw new TransformationException(String.format("A slot for instance %s has no defining feature", instance.getName()));
        }
        String varName = String.valueOf(instance.getName()) + "." + sf.getName();
        for (ValueSpecification value : slot.getValues()) {
            if (value.stringValue() == null) continue;
            this.m_initCodeCConfig = String.valueOf(this.m_initCodeCConfig) + varName + " = " + value.stringValue() + EOL;
        }
    }

    public void addInit(String language) {
        Operation initOp = this.m_bootLoader.getOwnedOperation(INIT_OP, null, null);
        OpaqueBehavior initBehavior = (OpaqueBehavior)this.m_bootLoader.createOwnedBehavior(initOp.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
        initOp.getMethods().add((Object)initBehavior);
        String code = this.m_initCode;
        if (this.m_initCodeCConfig.length() > 0) {
            code = String.valueOf(code) + this.m_initCodeCConfig;
        }
        if (this.m_initCodeCConnections.length() > 0) {
            code = String.valueOf(code) + this.m_initCodeCConnections;
        }
        Comparator<Class> comparator = new Comparator<Class>(){

            @Override
            public int compare(Class clazz1, Class clazz2) {
                InitPrecedence precedenceC1 = (InitPrecedence)UMLUtil.getStereotypeApplication((Element)clazz1, InitPrecedence.class);
                InitPrecedence precedenceC2 = (InitPrecedence)UMLUtil.getStereotypeApplication((Element)clazz2, InitPrecedence.class);
                if (precedenceC1 != null) {
                    if (ElementUtils.getNamedElementFromList((EList)precedenceC1.getInvokeAfter(), (String)clazz2.getName()) != null) {
                        return 1;
                    }
                    if (ElementUtils.getNamedElementFromList((EList)precedenceC1.getInvokeBefore(), (String)clazz2.getName()) != null) {
                        return -1;
                    }
                } else if (precedenceC2 != null) {
                    if (ElementUtils.getNamedElementFromList((EList)precedenceC2.getInvokeAfter(), (String)clazz1.getName()) != null) {
                        return -1;
                    }
                    if (ElementUtils.getNamedElementFromList((EList)precedenceC2.getInvokeBefore(), (String)clazz1.getName()) != null) {
                        return 1;
                    }
                }
                boolean ci1IsSingleton = DepUtils.isSingleton((Class)clazz1);
                boolean ci2IsSingleton = DepUtils.isSingleton((Class)clazz2);
                if (ci1IsSingleton) {
                    if (!ci2IsSingleton) {
                        return -1;
                    }
                } else if (ci2IsSingleton) {
                    return 1;
                }
                return 0;
            }
        };
        Class[] activationKeys = this.m_activation.keySet().toArray(new Class[0]);
        if (activationKeys.length > 0) {
            Arrays.sort(activationKeys, comparator);
            code = String.valueOf(code) + this.languageActivation(activationKeys);
        }
        code = this.m_initCodeRun != null ? String.valueOf(code) + this.m_initCodeRun : String.valueOf(code) + this.languageDefaultExecCode();
        if (activationKeys.length > 0) {
            code = String.valueOf(code) + this.languageDeactivation(activationKeys);
        }
        initBehavior.getLanguages().add((Object)language);
        initBehavior.getBodies().add((Object)code);
    }

    protected boolean instantiateViaBootloader(StructuralFeature structuralFeature) {
        if (structuralFeature.getType() instanceof Classifier) {
            return ((Classifier)structuralFeature.getType()).isAbstract();
        }
        return false;
    }

    public Class getUML() {
        return this.m_bootLoader;
    }

    public Property addInstance(Stack<Slot> slotPath, InstanceSpecification instance, Class implementation) throws TransformationException {
        String accessName = this.getPath(slotPath, instance, true);
        String varName = this.getPath(slotPath, instance, false);
        Property implemPart = null;
        Slot containerSlot = null;
        if (slotPath.size() > 0) {
            containerSlot = slotPath.peek();
            if (DepUtils.isShared((Slot)containerSlot)) {
                Stack referencePath = DepUtils.getAccessPath((InstanceSpecification)instance);
                String referenceVarName = this.getPath(referencePath, instance, false);
                this.m_initCode = String.valueOf(this.m_initCode) + this.languageAssignRef(accessName, referenceVarName);
                return implemPart;
            }
            if (this.instantiateViaBootloader(containerSlot.getDefiningFeature())) {
                implemPart = this.m_bootLoader.createOwnedAttribute(varName, (Type)implementation);
                this.m_initCode = String.valueOf(this.m_initCode) + accessName + " = &" + varName + EOL;
                implemPart.setIsComposite(true);
            }
        } else {
            implemPart = this.m_bootLoader.createOwnedAttribute(varName, (Type)implementation);
            implemPart.setIsComposite(true);
            this.m_initCode = String.valueOf(this.m_initCode) + this.languageCreateInstance(instance, implementation);
        }
        if (this.outputSizeof) {
            this.m_initCode = String.valueOf(this.m_initCode) + "cout << \"sizeof " + implementation.getName() + ": \" << sizeof (" + varName + ") << endl;" + EOL;
        }
        boolean unconnectedStart = AbstractBootLoaderGen.hasUnconnectedStartRoutine(implementation, containerSlot);
        boolean implementsIStart = this.implementsIStart(implementation);
        if (unconnectedStart || implementsIStart) {
            if (this.m_initCodeRun.equals(EMPTYSTR)) {
                this.m_initCodeRun = this.languageRunStart(varName, implementsIStart);
            } else {
                throw new TransformationException(String.format(Messages.BootLoaderGen_AtLeastOneBlockingCall, varName, this.m_initCodeRun));
            }
        }
        if (AbstractBootLoaderGen.hasUnconnectedLifeCycle(implementation, containerSlot)) {
            BasicEList varNameList = this.m_activation.get(implementation);
            if (varNameList == null) {
                varNameList = new BasicEList();
            }
            varNameList.add((Object)varName);
            this.m_activation.put(implementation, (EList<String>)varNameList);
        }
        if (implementation.getOwnedOperation(CREATE_CONNECTIONS, null, null) != null || implementation.getOwnedConnectors().size() > 0) {
            this.m_initCodeCConnections = String.valueOf(this.m_initCodeCConnections) + this.languageCreateConn(varName);
        }
        return implemPart;
    }

    public void addInstance(InstanceSpecification is, Stack<Slot> slotPath) throws TransformationException {
        Classifier implementation = DepUtils.getClassifier((InstanceSpecification)is);
        if (implementation instanceof Class) {
            this.addInstance(slotPath, is, (Class)implementation);
        }
        for (Slot slot : is.getSlots()) {
            InstanceSpecification subIS = DepUtils.getInstance((Slot)slot);
            slotPath.push(slot);
            if (subIS != null) {
                this.addInstance(subIS, slotPath);
            } else {
                this.instanceConfig(slotPath, is);
            }
            slotPath.pop();
        }
    }
}

