/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.export.wizards;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.export.Activator;
import org.eclipse.papyrus.designer.transformation.export.Messages;
import org.eclipse.papyrus.designer.transformation.export.SelectiveLazyCopier;
import org.eclipse.papyrus.designer.transformation.export.wizards.ExportElementPage;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class ExportElementWizard
extends Wizard
implements IExportWizard {
    private ExportElementPage page;
    protected EList<PackageableElement> selectedElements;

    public ExportElementWizard() {
        this.setWindowTitle(Messages.ExportElements_EXPORT_SELECTED_ELEMENT_NEW_UML);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection_) {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        this.selectedElements = new BasicEList();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedObject : structuredSelection.toList()) {
                EObject selectedEObject = EMFHelper.getEObject(selectedObject);
                if (!(selectedEObject instanceof PackageableElement)) continue;
                this.selectedElements.add((Object)((PackageableElement)selectedEObject));
            }
        }
        if (this.selectedElements.size() > 0) {
            this.page = new ExportElementPage(this.selectedElements);
            this.addPage((IWizardPage)this.page);
        } else {
            this.addErrorPage();
        }
    }

    private void addErrorPage() {
        WizardPage pageError = new WizardPage("Error"){

            public void createControl(Composite parent) {
                Label label = new Label(parent, 0);
                label.setText(Messages.ExportElements_ERROR_MSG);
                this.setControl((Control)label);
            }
        };
        this.addPage((IWizardPage)pageError);
    }

    public boolean performFinish() {
        this.page.setErrorMessage(null);
        try {
            ModelManagement newModel = ModelManagement.createNewModel((String)this.page.getModelName());
            newModel.setURI(this.page.getOutputURI());
            Package rootPkg = PackageUtil.getRootPackage((Element)((Element)this.selectedElements.get(0)));
            if (this.page.useTransitiveClosure()) {
                LazyCopier copier = new LazyCopier(rootPkg, newModel.getModel(), LazyCopier.CopyExtResources.NONE, true);
                for (PackageableElement element : this.selectedElements) {
                    copier.getCopy((Element)element);
                }
            } else {
                SelectiveLazyCopier copier = new SelectiveLazyCopier(rootPkg, newModel.getModel(), LazyCopier.CopyExtResources.NONE, true);
                for (PackageableElement element : this.selectedElements) {
                    copier.setFilter((EObject)element);
                    copier.getCopy((Element)element);
                }
            }
            newModel.save();
            newModel.dispose();
        }
        catch (TransformationException e) {
            Activator.log.error((Throwable)e);
        }
        return true;
    }
}

