/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EAccessKind implements Enumerator
{
    READ(0, "read", "read"),
    WRITE(1, "write", "write"),
    READ_WRITE(2, "readWrite", "readWrite");

    public static final int READ_VALUE = 0;
    public static final int WRITE_VALUE = 1;
    public static final int READ_WRITE_VALUE = 2;
    private static final EAccessKind[] VALUES_ARRAY;
    public static final List<EAccessKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EAccessKind[]{READ, WRITE, READ_WRITE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EAccessKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EAccessKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EAccessKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EAccessKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EAccessKind get(int value) {
        switch (value) {
            case 0: {
                return READ;
            }
            case 1: {
                return WRITE;
            }
            case 2: {
                return READ_WRITE;
            }
        }
        return null;
    }

    private EAccessKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

