/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.xtend;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class BehaviorUtil {
    private static final String DEFAULT_LANGUAGE = "C++";

    public static void set(Behavior behavior, String selectLanguage, String textblock) {
        if (behavior instanceof OpaqueBehavior) {
            OpaqueBehavior ob = (OpaqueBehavior)behavior;
            if (ob.getLanguages().size() == 0) {
                ob.getLanguages().add((Object)(selectLanguage != null ? selectLanguage : DEFAULT_LANGUAGE));
                ob.getBodies().add((Object)textblock);
            } else {
                int i = 0;
                for (String language : ob.getLanguages()) {
                    if (selectLanguage != null && !selectLanguage.equals(language)) continue;
                    if (i >= ob.getBodies().size()) break;
                    ob.getBodies().set(i, (Object)textblock);
                    break;
                }
            }
        }
    }

    public static void set(Behavior behavior, String textblock) {
        BehaviorUtil.set(behavior, DEFAULT_LANGUAGE, textblock);
    }

    public static OpaqueBehavior createOpaqueBehavior(BehavioredClassifier clazz, Operation operation) {
        OpaqueBehavior ob = (OpaqueBehavior)clazz.createOwnedBehavior(operation.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
        ob.setSpecification((BehavioralFeature)operation);
        return ob;
    }

    public static OpaqueBehavior createOpaqueEffect(Transition transition) {
        OpaqueBehavior ob = (OpaqueBehavior)transition.createEffect("", UMLPackage.eINSTANCE.getOpaqueBehavior());
        return ob;
    }

    public static OpaqueExpression createOpaqueExpression(Constraint constraint, String guardCode) {
        OpaqueExpression oe = (OpaqueExpression)constraint.createSpecification("", null, UMLPackage.eINSTANCE.getOpaqueExpression());
        oe.getLanguages().add((Object)DEFAULT_LANGUAGE);
        oe.getBodies().add((Object)guardCode);
        return oe;
    }

    public static String body(Constraint constraint) {
        OpaqueExpression oe;
        if (constraint.getSpecification() instanceof OpaqueExpression && (oe = (OpaqueExpression)constraint.getSpecification()).getBodies().size() > 0) {
            return (String)oe.getBodies().get(0);
        }
        return constraint.getSpecification().stringValue();
    }

    public static Operation createOperation(Class clazz, String name, Type retType) {
        Operation operation = clazz.createOwnedOperation(name, null, null);
        if (retType != null) {
            Parameter parameter = operation.createOwnedParameter("ret", retType);
            parameter.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        }
        return operation;
    }

    public static String body(Behavior behavior) {
        return BehaviorUtil.body(behavior, DEFAULT_LANGUAGE);
    }

    public static String body(Behavior behavior, String selectLanguage) {
        if (behavior instanceof OpaqueBehavior) {
            OpaqueBehavior ob = (OpaqueBehavior)behavior;
            int i = 0;
            for (String language : ob.getLanguages()) {
                if (selectLanguage != null && !selectLanguage.equals(language)) continue;
                if (i >= ob.getBodies().size()) break;
                return (String)ob.getBodies().get(i);
            }
        }
        return null;
    }

    public static String body(Operation operation, String selectLanguage) {
        for (Behavior method : operation.getMethods()) {
            String body = BehaviorUtil.body(method, selectLanguage);
            if (body == null) continue;
            return body;
        }
        return null;
    }

    public static String body(Operation operation) {
        return BehaviorUtil.body(operation, null);
    }

    public static void set(Operation operation, String selectLanguage, String textblock) {
        Behavior method2;
        for (Behavior method2 : operation.getMethods()) {
            OpaqueBehavior ob;
            if (!(method2 instanceof OpaqueBehavior) || (ob = (OpaqueBehavior)method2).getLanguages().size() <= 0 || selectLanguage != null && !((String)ob.getLanguages().get(0)).equals(selectLanguage)) continue;
            BehaviorUtil.set((Behavior)ob, selectLanguage, textblock);
            return;
        }
        method2 = BehaviorUtil.createOpaqueBehavior((BehavioredClassifier)operation.getClass_(), operation);
        BehaviorUtil.set(method2, selectLanguage, textblock);
    }

    public static void set(Operation operation, String textblock) {
        BehaviorUtil.set(operation, null, textblock);
    }

    public static void appendBody(Behavior behavior, String codeToAppend) {
        String body = BehaviorUtil.body(behavior, null);
        if (body != null) {
            BehaviorUtil.set(behavior, null, String.valueOf(body) + "\n" + codeToAppend);
        } else {
            BehaviorUtil.set(behavior, null, codeToAppend);
        }
    }

    public static void appendBody(Operation operation, String codeToAppend) {
        EList methods = operation.getMethods();
        OpaqueBehavior opaque = methods.size() > 0 && methods.get(0) instanceof OpaqueBehavior ? (OpaqueBehavior)methods.get(0) : BehaviorUtil.createOpaqueBehavior((BehavioredClassifier)operation.getClass_(), operation);
        BehaviorUtil.appendBody((Behavior)opaque, codeToAppend);
    }

    public static void prefixBody(Behavior behavior, String codeToPrefix) {
        String body = BehaviorUtil.body(behavior, null);
        if (body != null) {
            BehaviorUtil.set(behavior, null, String.valueOf(codeToPrefix) + "\n" + body);
        } else {
            BehaviorUtil.set(behavior, null, codeToPrefix);
        }
    }

    public static void prefixBody(Operation operation, String codeToPrefix) {
        EList methods = operation.getMethods();
        OpaqueBehavior opaque = methods.size() > 0 && methods.get(0) instanceof OpaqueBehavior ? (OpaqueBehavior)methods.get(0) : BehaviorUtil.createOpaqueBehavior((BehavioredClassifier)operation.getClass_(), operation);
        BehaviorUtil.prefixBody((Behavior)opaque, codeToPrefix);
    }
}

