/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.realtime.pycpa.ecore.pycpa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SchedulerKind implements Enumerator
{
    ROUND_ROBIN(0, "ROUND_ROBIN", "ROUND_ROBIN"),
    SP_NP(1, "SP_NP", "SP_NP"),
    SP_P(2, "SP_P", "SP_P"),
    SP_PACTIVOFFSETS(3, "SP_P_ACTIVOFFSETS", "SP_P_ACTIVOFFSETS");

    public static final int ROUND_ROBIN_VALUE = 0;
    public static final int SP_NP_VALUE = 1;
    public static final int SP_P_VALUE = 2;
    public static final int SP_PACTIVOFFSETS_VALUE = 3;
    private static final SchedulerKind[] VALUES_ARRAY;
    public static final List<SchedulerKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SchedulerKind[]{ROUND_ROBIN, SP_NP, SP_P, SP_PACTIVOFFSETS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SchedulerKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulerKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulerKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulerKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulerKind get(int value) {
        switch (value) {
            case 0: {
                return ROUND_ROBIN;
            }
            case 1: {
                return SP_NP;
            }
            case 2: {
                return SP_P;
            }
            case 3: {
                return SP_PACTIVOFFSETS;
            }
        }
        return null;
    }

    private SchedulerKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

