/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.FunctionScript;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TransformationUtil {
    public static Map<Class, StateMachine> getStateMachineClass(Package pack) {
        final HashMap<Class, StateMachine> map = new HashMap<Class, StateMachine>();
        Consumer<Class> _function = new Consumer<Class>(){

            @Override
            public void accept(Class it) {
                StateMachine behavior = (StateMachine)IterableExtensions.head((Iterable)Iterables.filter((Iterable)it.getOwnedBehaviors(), StateMachine.class));
                if (behavior != null) {
                    map.put(it, behavior);
                }
            }
        };
        Iterables.filter((Iterable)pack.getOwnedElements(), Class.class).forEach(_function);
        return map;
    }

    public static Pseudostate firstPseudoState(Region region, PseudostateKind kind) {
        EList _subvertices = region.getSubvertices();
        for (Vertex vertex : _subvertices) {
            Pseudostate pseudoState;
            PseudostateKind _kind;
            boolean _equals;
            if (!(vertex instanceof Pseudostate) || !(_equals = Objects.equal((Object)(_kind = (pseudoState = (Pseudostate)vertex).getKind()), (Object)kind))) continue;
            return pseudoState;
        }
        return null;
    }

    public static List<State> findCompositeStatesInRegion(Vertex des1, Vertex des2) {
        ArrayList<State> ret = new ArrayList<State>();
        ArrayList<State> path1 = new ArrayList<State>();
        if (des1 instanceof State) {
            path1.add((State)des1);
        }
        State owner1 = des1.getContainer().getState();
        while (owner1 != null) {
            path1.add(owner1);
            owner1 = owner1.getContainer().getState();
        }
        Vertex owner2 = des2;
        while (owner2 != null && ret.isEmpty()) {
            for (State s : path1) {
                if (!Objects.equal((Object)s.getContainer(), (Object)owner2.getContainer()) || !(owner2 instanceof State)) continue;
                ret.add(s);
                ret.add((State)owner2);
            }
            owner2 = owner2.getContainer().getState();
        }
        return ret;
    }

    public static State findInitialState(Region r) {
        Pseudostate pseudoDefault = TransformationUtil.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
        if (pseudoDefault != null) {
            Vertex _target = ((Transition)IterableExtensions.head((Iterable)pseudoDefault.getOutgoings())).getTarget();
            return (State)_target;
        }
        return null;
    }

    public static String getInitialEffect(Region r) {
        Transition t;
        Pseudostate pseudoDefault = TransformationUtil.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
        if (pseudoDefault != null && (t = (Transition)IterableExtensions.head((Iterable)pseudoDefault.getOutgoings())).getEffect() != null && t.getEffect() instanceof OpaqueBehavior) {
            Behavior _effect = t.getEffect();
            return (String)IterableExtensions.head((Iterable)((OpaqueBehavior)_effect).getBodies());
        }
        return "//no initial effect is defined";
    }

    public static List<State> transitiveSubStates(State parent) {
        final ArrayList<State> ret = new ArrayList<State>();
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                Iterables.addAll(ret, (Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class));
                Consumer<State> _function = new Consumer<State>(){

                    @Override
                    public void accept(State it) {
                        ret.addAll(TransformationUtil.transitiveSubStates(it));
                    }
                };
                Iterables.filter((Iterable)r.getSubvertices(), State.class).forEach(_function);
            }
        }
        return ret;
    }

    public static List<State> transitiveSubStates(Region parent) {
        final ArrayList<State> ret = new ArrayList<State>();
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return !(it instanceof FinalState);
            }
        };
        Consumer<State> _function_1 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                ret.add(it);
                ret.addAll(TransformationUtil.transitiveSubStates(it));
            }
        };
        IterableExtensions.filter((Iterable)Iterables.filter((Iterable)parent.getSubvertices(), State.class), (Functions.Function1)_function).forEach(_function_1);
        return ret;
    }

    public static String eventName(Event event) {
        char[] _charArray;
        String _xblockexpression = null;
        String name = "";
        boolean repeat = false;
        char[] cArray = _charArray = event.getName().toCharArray();
        int n = _charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isAlphabetic(c) || Character.isDigit(c)) {
                String _name = name;
                name = String.valueOf(_name) + Character.valueOf(c);
                repeat = false;
            } else if (!repeat) {
                String _name_1 = name;
                name = String.valueOf(_name_1) + "_";
                repeat = true;
            }
            ++n2;
        }
        _xblockexpression = name;
        return _xblockexpression;
    }

    public static String eventID(Event event) {
        String _upperCase = TransformationUtil.eventName(event).toUpperCase();
        return String.valueOf(_upperCase) + "_ID";
    }

    public static boolean isSavehistory(Region topRegion, Region r) {
        boolean _greaterThan;
        Functions.Function1<Pseudostate, Boolean> _function = new Functions.Function1<Pseudostate, Boolean>(){

            public Boolean apply(Pseudostate it) {
                PseudostateKind _kind = it.getKind();
                return Objects.equal((Object)_kind, (Object)PseudostateKind.SHALLOW_HISTORY_LITERAL);
            }
        };
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), Pseudostate.class), (Functions.Function1)_function));
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            return true;
        }
        return TransformationUtil.isSaveDeepHistory(topRegion, r);
    }

    public static boolean isBehaviorExist(Behavior b) {
        if (b != null && b instanceof OpaqueBehavior) {
            boolean _isEmpty = GenUtils.getBodyFromOB((OpaqueBehavior)((OpaqueBehavior)b), (Pattern)FunctionScript.CLANGUAGE).isEmpty();
            return !_isEmpty;
        }
        return false;
    }

    public static boolean hasTriggerlessTransition(State s) {
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                Functions.Function1<Trigger, Event> _function = new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it) {
                        return it.getEvent();
                    }
                };
                return ListExtensions.map((List)it.getTriggers(), (Functions.Function1)_function).isEmpty();
            }
        };
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)s.getOutgoings(), (Functions.Function1)_function));
        return _size > 0;
    }

    public static boolean hasTriggerlessTransition(StateMachine sm) {
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return !(it instanceof FinalState);
            }
        };
        Iterable states = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)sm.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function);
        for (State s : states) {
            boolean _greaterThan;
            Functions.Function1<Transition, Boolean> _function_1 = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    Functions.Function1<Trigger, Event> _function = new Functions.Function1<Trigger, Event>(){

                        public Event apply(Trigger it) {
                            return it.getEvent();
                        }
                    };
                    return ListExtensions.map((List)it.getTriggers(), (Functions.Function1)_function).isEmpty();
                }
            };
            int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)s.getOutgoings(), (Functions.Function1)_function_1));
            boolean bl = _greaterThan = _size > 0;
            if (!_greaterThan) continue;
            return true;
        }
        return false;
    }

    public static boolean isSaveDeepHistory(Region topRegion, Region r) {
        boolean _notEquals;
        boolean _greaterThan;
        Functions.Function1<Pseudostate, Boolean> _function = new Functions.Function1<Pseudostate, Boolean>(){

            public Boolean apply(Pseudostate it) {
                PseudostateKind _kind = it.getKind();
                return Objects.equal((Object)_kind, (Object)PseudostateKind.DEEP_HISTORY_LITERAL);
            }
        };
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), Pseudostate.class), (Functions.Function1)_function));
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            return true;
        }
        boolean bl2 = _notEquals = !Objects.equal((Object)r, (Object)topRegion);
        if (_notEquals) {
            Region nextRegion = r.getState().getContainer();
            return TransformationUtil.isSaveDeepHistory(topRegion, nextRegion);
        }
        return false;
    }
}

