/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.fcm.profile.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.components.FCM.Connector;
import org.eclipse.papyrus.designer.components.FCM.ContainerRule;
import org.eclipse.papyrus.designer.components.FCM.InteractionComponent;
import org.eclipse.papyrus.designer.components.FCM.RuleApplication;
import org.eclipse.papyrus.designer.components.fcm.profile.IEmbeddingRule;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class FCMUtil {
    public static EList<ValueSpecification> getConfigurationValue(InstanceSpecification specification, String configPropertyName) {
        if (specification != null) {
            for (Slot currentSlot : specification.getSlots()) {
                if (currentSlot.getDefiningFeature() == null || !currentSlot.getDefiningFeature().getName().equals(configPropertyName)) continue;
                return currentSlot.getValues();
            }
        }
        return null;
    }

    public static Interface findInterfaceByName(EList<Interface> interfaces, String interfaceName) {
        for (Interface currentInterface : interfaces) {
            if (!currentInterface.getName().equals(interfaceName)) continue;
            return currentInterface;
        }
        return null;
    }

    public static void generateDefaultConnectionPattern(InteractionComponent connectorComp) {
        Collaboration connectionPattern = UMLFactory.eINSTANCE.createCollaboration();
        connectorComp.getBase_Class().getNestedClassifiers().add((Object)connectionPattern);
        connectionPattern.setName(String.valueOf(connectorComp.getBase_Class().getName()) + "ConnectionPattern");
        Property connectorRole = connectionPattern.createOwnedAttribute("connector", (Type)connectorComp.getBase_Class(), 1, 1);
        for (Port port : connectorComp.getBase_Class().getOwnedPorts()) {
            Property role = connectionPattern.createOwnedAttribute(port.getName(), null);
            org.eclipse.uml2.uml.Connector connector = connectionPattern.createOwnedConnector("");
            ConnectorEnd source = connector.createEnd();
            source.setRole((ConnectableElement)port);
            source.setPartWithPort(connectorRole);
            ConnectorEnd target = connector.createEnd();
            target.setRole((ConnectableElement)role);
        }
        connectorComp.setConnectionPattern(connectionPattern);
    }

    public static void generateCollaborationUse(Connector connector) {
        InteractionComponent connectorCompGen = connector.getIc();
        if (!(connectorCompGen instanceof InteractionComponent)) {
            return;
        }
        InteractionComponent connectorComp = connectorCompGen;
        Collaboration connectionPattern = connectorComp.getConnectionPattern();
        if (connectionPattern == null) {
            FCMUtil.generateDefaultConnectionPattern(connectorComp);
            connectionPattern = connectorComp.getConnectionPattern();
        }
        Class composite = (Class)connector.getBase_Connector().getOwner();
        RoleBindingTable bindingTable = FCMUtil.getConnectorRoleBindings(connector);
        if (bindingTable == null) {
            return;
        }
        CollaborationUse collaborationUse = composite.createCollaborationUse("useOf" + connectionPattern.getName());
        collaborationUse.setType(connectionPattern);
        Iterator<ConnectableElement> i = bindingTable.iterator();
        while (i.hasNext()) {
            ConnectableElement role = i.next();
            Dependency roleBinding = collaborationUse.createRoleBinding(String.valueOf(role.getName()) + "RoleBinding");
            roleBinding.getSuppliers().add((Object)role);
            Iterator<NamedElement> j = bindingTable.getEntry(role).iterator();
            while (j.hasNext()) {
                roleBinding.getClients().add((Object)j.next());
            }
        }
    }

    public static RoleBindingTable getConnectorRoleBindings(Connector connector) {
        IConfigurationElement[] configElements;
        InteractionComponent connectorCompGen = connector.getIc();
        if (!(connectorCompGen instanceof InteractionComponent)) {
            return null;
        }
        InteractionComponent type = connectorCompGen;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor("fcmEmbeddingRule");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object obj;
                String extConnName = configElement.getAttribute("connectorName");
                if (extConnName.equals(type.getBase_Class().getName()) && (obj = configElement.createExecutableExtension("class")) instanceof IEmbeddingRule) {
                    return ((IEmbeddingRule)obj).getRoleBindings(connector);
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return null;
    }

    public static EList<ContainerRule> getAllContainerRules(Element element) {
        UniqueEList list = new UniqueEList();
        if (element != null) {
            for (EObject eObj : element.getStereotypeApplications()) {
                if (!(eObj instanceof RuleApplication)) continue;
                list.addAll(((RuleApplication)eObj).getContainerRule());
                break;
            }
            element = element.getOwner();
            if (element != null) {
                list.addAll(FCMUtil.getAllContainerRules(element));
            }
        }
        return list;
    }

    public static final class RoleBindingTable {
        private HashMap<ConnectableElement, List<NamedElement>> table = new HashMap();

        public void addEntry(ConnectableElement role, List<NamedElement> playedBy) {
            this.table.put(role, playedBy);
        }

        public List<NamedElement> getEntry(ConnectableElement role) {
            return this.table.get(role);
        }

        public Iterator<ConnectableElement> iterator() {
            return this.table.keySet().iterator();
        }

        public HashMap<ConnectableElement, List<NamedElement>> getTable() {
            return this.table;
        }

        public ConnectableElement getRoleKeyByName(String roleName) {
            for (ConnectableElement role : this.table.keySet()) {
                if (!role.getName().equals(roleName)) continue;
                return role;
            }
            return null;
        }
    }
}

