/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.tracing.barectf.library;

import com.google.common.base.Objects;
import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.common.base.StringUtils;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.InstrumentCTF;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.ModelQNames;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class InitCTF {
    public static boolean copyCode(String fileName, IFolder targetFolder) {
        try {
            boolean _xblockexpression = false;
            Bundle bundle = FrameworkUtil.getBundle(InstrumentCTF.class);
            String codeFolder = "code/";
            URL inputURL = bundle.getResource("code/" + fileName);
            IFile createdFile = targetFolder.getFile(fileName);
            boolean _exists = createdFile.exists();
            if (_exists) {
                createdFile.setContents(inputURL.openStream(), true, true, null);
            } else {
                createdFile.create(inputURL.openStream(), true, null);
            }
            _xblockexpression = TransformationContext.current.keepFiles.add(createdFile.getFullPath().toString());
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean initCode(IFolder srcCTF, Package cdp) {
        try {
            boolean _xblockexpression = false;
            NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS((Element)cdp, (String)ModelQNames.BareCTFInit);
            Classifier initCl = (Classifier)_qualifiedElementFromRS;
            if (initCl != null) {
                InstanceSpecification is = UMLFactory.eINSTANCE.createInstanceSpecification();
                Classifier ctfInitCopy = (Classifier)TransformationContext.current.copier.getCopy((Element)initCl);
                Property metadataPath = ctfInitCopy.getAttribute("metadataPath", null);
                ValueSpecification _createDefaultValue = metadataPath.createDefaultValue(null, metadataPath.getType(), UMLPackage.eINSTANCE.getLiteralString());
                LiteralString defaultVal = (LiteralString)_createDefaultValue;
                String _file = FileLocator.resolve((URL)TransformationContext.current.project.getLocationURI().toURL()).getFile();
                String projectFN = String.valueOf(_file) + "/src-gen/ctf/metadata";
                boolean _equals = Objects.equal((Object)File.separator, (Object)"\\");
                if (_equals) {
                    boolean _startsWith = projectFN.startsWith("/");
                    if (_startsWith) {
                        projectFN = projectFN.substring(1);
                    }
                    projectFN = projectFN.replace("/", "\\\\");
                }
                defaultVal.setValue(StringUtils.quote((String)projectFN));
                is.setName("ctfInit");
                is.getClassifiers().add((Object)ctfInitCopy);
                cdp.getPackagedElements().add((Object)is);
            }
            String platformFile = "barectf-platform-fs";
            InitCTF.copyCode("barectf-platform-fs.h", srcCTF);
            InitCTF.copyCode("barectf-platform-fs.c", srcCTF);
            String initCode = "barectf-init";
            InitCTF.copyCode("barectf-init.h", srcCTF);
            _xblockexpression = InitCTF.copyCode("barectf-init.c", srcCTF);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

