/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import java.util.concurrent.CancellationException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.designer.transformation.base.Activator;
import org.eclipse.papyrus.designer.transformation.base.Messages;
import org.eclipse.papyrus.designer.transformation.base.utils.RunnableWithResult;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;

public class CommandSupport {
    public static void exec(String label, ExecutionEvent event, Runnable command) {
        ServiceUtilsForHandlers serviceUtils = ServiceUtilsForHandlers.getInstance();
        try {
            CommandSupport.exec(serviceUtils.getTransactionalEditingDomain((Object)event), label, command);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.CommandSupport_NoEditingDomain, (Throwable)e);
        }
    }

    public static void exec(EObject eObject, String label, Runnable command) {
        CommandSupport.exec(TransactionUtil.getEditingDomain((EObject)eObject), label, command);
    }

    public static void exec(String label, ExecutionEvent event, final RunnableWithResult command) {
        ServiceUtilsForHandlers serviceUtils = ServiceUtilsForHandlers.getInstance();
        try {
            TransactionalEditingDomain domain = serviceUtils.getTransactionalEditingDomain((Object)event);
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, label){

                public void doExecute() {
                    CommandResult result = command.run();
                    IStatus status = result.getStatus();
                    if (!status.isOK()) {
                        throw new CancellationException();
                    }
                }
            });
        }
        catch (CancellationException domain) {
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.CommandSupport_NoEditingDomain, (Throwable)e);
        }
    }

    public static void exec(TransactionalEditingDomain domain, String label, final Runnable command) {
        if (domain == null) {
            command.run();
        } else {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, label){

                public void doExecute() {
                    command.run();
                }
            });
        }
    }

    public static void exec(TransactionalEditingDomain domain, Command command) {
        domain.getCommandStack().execute(command);
    }
}

