/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.JavaParser;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ParseException;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.CompilationUnit;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.IProjectExplorerNodeVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.ClassifierCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.CompilationUnitAnalyser;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.UmlUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class ReverseSelectedNodeVisitor
implements IProjectExplorerNodeVisitor {
    protected CompilationUnitAnalyser javaAnalyser;
    protected ClassifierCatalog classifierCatalog;
    protected List<String> reversedElementQualifiedNames;
    protected List<NamedElement> reversedNamedElement;

    public ReverseSelectedNodeVisitor(Package rootPackage, String generatedPackageName, List<String> searchPaths, List<String> creationPaths, List<String> qualifiedNamesInProjects) {
        this.javaAnalyser = new CompilationUnitAnalyser(rootPackage, generatedPackageName, searchPaths, creationPaths, qualifiedNamesInProjects);
        this.reversedElementQualifiedNames = new ArrayList<String>();
        this.reversedNamedElement = new ArrayList<NamedElement>();
        this.classifierCatalog = this.javaAnalyser.getClassifierCatalog();
    }

    public ReverseSelectedNodeVisitor(Parameters parameters) {
        this(parameters.getUmlRootPackage(), parameters.getPackageName(), parameters.getSearchPaths(), parameters.getCreationPaths(), parameters.getQualifiedNamesInProjects());
    }

    public List<String> getReversedElementQualifiedNames() {
        return this.reversedElementQualifiedNames;
    }

    public List<NamedElement> getReversedNamedElement() {
        return this.reversedNamedElement;
    }

    protected void addReversedName(String name) {
        this.reversedElementQualifiedNames.add(name);
        Classifier namedElement = this.classifierCatalog.getClassifier(name);
        if (namedElement != null) {
            this.reversedNamedElement.add((NamedElement)namedElement);
        }
    }

    @Override
    public void visitICompilationUnit(ICompilationUnit unit) {
        this.processITypeRoot((ITypeRoot)unit);
    }

    protected void processITypeRoot(ITypeRoot unit) {
        System.out.println("try to reverseType(" + unit.getElementName() + ")");
        try {
            String source = unit.getSource();
            if (source == null) {
                System.err.println("No source attached to unit '" + unit.getElementName() + "'");
                return;
            }
            CompilationUnit cu = JavaParser.parse((Reader)new StringReader(source), (boolean)true);
            this.javaAnalyser.processCompilationUnit(cu);
            this.addReversedName(unit.findPrimaryType().getFullyQualifiedName('.'));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitIClassFile(IClassFile unit) {
        this.processITypeRoot((ITypeRoot)unit);
    }

    @Override
    public void visitIPackageFragment(IPackageFragment node) {
    }

    @Override
    public void visitIPackageFragmentRoot(IPackageFragmentRoot node) {
    }

    @Override
    public void visitIClasspathContainer(IClasspathContainer node) {
    }

    @Override
    public void visitIProject(IProject node) {
    }

    @Override
    public void visitIJavaProject(IJavaProject node) {
    }

    @Override
    public void postVisit() {
    }

    @Override
    public void preVisit() {
        if (this.javaAnalyser != null) {
            UmlUtils.applyCodeGenerationProfilesToModel((Model)this.javaAnalyser.getRootModel());
        }
    }

    public static class Parameters {
        protected List<String> searchPaths;
        protected List<String> creationPaths;
        protected Package umlRootPackage;
        protected String packageName;
        protected List<String> qualifiedNamesInProjects;

        public List<String> getSearchPaths() {
            return this.searchPaths;
        }

        public void setSearchPaths(List<String> searchPaths) {
            this.searchPaths = searchPaths;
        }

        public List<String> getCreationPaths() {
            return this.creationPaths;
        }

        public void setCreationPaths(List<String> creationPaths) {
            this.creationPaths = creationPaths;
        }

        public Package getUmlRootPackage() {
            return this.umlRootPackage;
        }

        public void setUmlRootPackage(Package umlModel) {
            this.umlRootPackage = umlModel;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public List<String> getQualifiedNamesInProjects() {
            return this.qualifiedNamesInProjects;
        }

        public void setQualifiedNamesInProjects(List<String> qualifiedNamesInProjects) {
            this.qualifiedNamesInProjects = qualifiedNamesInProjects;
        }
    }
}

