/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.validation.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public class OperationsWithTwoReturnValues
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Operation operation = (Operation)ctx.getTarget();
        boolean firstReturn = true;
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            if (firstReturn) {
                firstReturn = false;
                continue;
            }
            return ctx.createFailureStatus(new Object[]{String.format("The operation '%s' has more than one return parameter. It must have at most one", operation.getName())});
        }
        return ctx.createSuccessStatus();
    }
}

