/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.validity.locator.CompleteOCLCSUIConstraintLocator;
import org.eclipse.ocl.examples.validity.locator.DelegateUIConstraintLocator;
import org.eclipse.ocl.examples.validity.locator.PivotUIConstraintLocator;
import org.eclipse.ocl.examples.validity.locator.UMLUIConstraintLocator;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.evaluation.AbstractConstraintEvaluator;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public abstract class AbstractPivotConstraintLocator
extends org.eclipse.ocl.examples.emf.validation.validity.locator.AbstractConstraintLocator {
    public static void initialize() {
        org.eclipse.ocl.examples.emf.validation.validity.locator.AbstractConstraintLocator.initialize();
        ValidityManager.addConstraintLocator((String)"http://www.eclipse.org/ocl/2015/CompleteOCLCS", (ConstraintLocator.Descriptor)CompleteOCLCSUIConstraintLocator.INSTANCE);
        ValidityManager.addConstraintLocator((String)"http://www.eclipse.org/ocl/2015/Pivot", (ConstraintLocator.Descriptor)PivotUIConstraintLocator.INSTANCE);
        ValidityManager.addConstraintLocator((String)"http://www.eclipse.org/uml2/2.0.0/UML", (ConstraintLocator.Descriptor)UMLUIConstraintLocator.INSTANCE);
        ValidityManager.addConstraintLocator((String)"http://www.eclipse.org/uml2/3.0.0/UML", (ConstraintLocator.Descriptor)UMLUIConstraintLocator.INSTANCE);
        ValidityManager.addConstraintLocator((String)"http://www.eclipse.org/uml2/4.0.0/UML", (ConstraintLocator.Descriptor)UMLUIConstraintLocator.INSTANCE);
        ValidityManager.addConstraintLocator((String)"http://www.eclipse.org/uml2/5.0.0/UML", (ConstraintLocator.Descriptor)UMLUIConstraintLocator.INSTANCE);
        ValidityManager.addConstraintLocator(null, (ConstraintLocator.Descriptor)DelegateUIConstraintLocator.INSTANCE);
    }

    protected @NonNull EvaluationVisitor createEvaluationVisitor(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull ExpressionInOCL query, @Nullable Object contextObject, @Nullable Monitor monitor) {
        EvaluationVisitor evaluationVisitor = environmentFactory.createEvaluationVisitor(contextObject, query, null);
        evaluationVisitor.setMonitor(monitor);
        return evaluationVisitor;
    }

    protected @NonNull ExpressionInOCL getQuery(@NonNull PivotMetamodelManager metamodelManager, @NonNull Constraint constraint) throws ParserException {
        LanguageExpression specification = constraint.getOwnedSpecification();
        assert (specification != null);
        return ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)metamodelManager.getEnvironmentFactory()).parseSpecification(specification);
    }

    public @Nullable Resource getSourceResource(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof EObject)) {
            return null;
        }
        return ((EObject)constrainingObject).eResource();
    }

    protected static abstract class AbstractConstraintLocator
    extends AbstractConstraintEvaluator<Diagnostic> {
        protected final @NonNull PivotMetamodelManager metamodelManager;
        protected final @Nullable Object object;

        protected AbstractConstraintLocator(@NonNull PivotMetamodelManager metamodelManager, @NonNull ExpressionInOCL expression, @Nullable Object object) {
            super(expression);
            this.metamodelManager = metamodelManager;
            this.object = object;
        }

        protected Diagnostic handleExceptionResult(@NonNull Throwable e) {
            String message = StringUtil.bind((String)PivotMessagesInternal.ValidationConstraintException_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e});
            return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{this.object});
        }

        protected Diagnostic handleFailureResult(@Nullable Object result) {
            String message = this.getConstraintResultMessage(result);
            int severity = this.getConstraintResultSeverity(result);
            return new BasicDiagnostic(severity, "org.eclipse.emf.ecore", 0, message, new Object[]{this.object});
        }

        protected Diagnostic handleInvalidExpression(@NonNull String message) {
            return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{this.object});
        }

        protected Diagnostic handleInvalidResult(@NonNull InvalidValueException e) {
            String message = StringUtil.bind((String)PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage()});
            return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{this.object});
        }

        protected Diagnostic handleSuccessResult() {
            return null;
        }
    }
}

