/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.IndexableIterable;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public abstract class AbstractFragment
implements InheritanceFragment {
    public final @NonNull CompleteInheritance derivedInheritance;
    public final @NonNull CompleteInheritance baseInheritance;

    public AbstractFragment(@NonNull CompleteInheritance derivedInheritance, @NonNull CompleteInheritance baseInheritance) {
        this.derivedInheritance = derivedInheritance;
        this.baseInheritance = baseInheritance;
    }

    @Override
    public @NonNull Operation getActualOperation(@NonNull Operation apparentOperation) {
        Operation localOperation = this.getLocalOperation(apparentOperation);
        if (localOperation == null && this.derivedInheritance == this.baseInheritance) {
            localOperation = apparentOperation;
        }
        if (localOperation == null) {
            Operation bestOverload = null;
            CompleteInheritance bestInheritance = null;
            int bestDepth = -1;
            int minDepth = this.baseInheritance.getDepth();
            int depth = this.derivedInheritance.getDepth() - 1;
            while (depth >= minDepth) {
                IndexableIterable<InheritanceFragment> derivedSuperFragments = this.derivedInheritance.getSuperFragments(depth);
                for (InheritanceFragment derivedSuperFragment : derivedSuperFragments) {
                    Operation overload;
                    CompleteInheritance superInheritance = derivedSuperFragment.getBaseInheritance();
                    InheritanceFragment superFragment = superInheritance.getFragment(this.baseInheritance);
                    if (superFragment == null || (overload = superFragment.getLocalOperation(apparentOperation)) == null) continue;
                    if (bestInheritance == null) {
                        bestDepth = depth;
                        bestInheritance = superInheritance;
                        bestOverload = overload;
                        continue;
                    }
                    if (depth == bestDepth) {
                        bestOverload = null;
                        depth = -1;
                        break;
                    }
                    if (bestInheritance.isSubInheritanceOf(superInheritance)) continue;
                    bestOverload = null;
                    depth = -1;
                    break;
                }
                --depth;
            }
            if (bestOverload != null) {
                localOperation = bestOverload;
            } else if (bestInheritance == null) {
                localOperation = apparentOperation;
            } else {
                throw new InvalidValueException(PivotMessages.AmbiguousOperation, apparentOperation, this.derivedInheritance);
            }
        }
        return localOperation;
    }

    @Override
    public final @NonNull InheritanceFragment getBaseFragment() {
        return this.baseInheritance.getSelfFragment();
    }

    @Override
    public final @NonNull CompleteInheritance getBaseInheritance() {
        return this.baseInheritance;
    }

    @Override
    public final @NonNull CompleteInheritance getDerivedInheritance() {
        return this.derivedInheritance;
    }

    public @NonNull String toString() {
        return String.valueOf(this.derivedInheritance.toString()) + "__" + this.baseInheritance.toString();
    }
}

