/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml;

import java.net.URL;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.uml.internal.labels.CommentLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.LiteralBooleanLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.LiteralIntegerLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.LiteralNullLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.LiteralRealLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.LiteralStringLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.LiteralUnlimitedNaturalLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.NamedElementLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.OpaqueExpressionLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.PackageImportLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.SlotLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.labels.UMLElementExtensionLabelGenerator;
import org.eclipse.ocl.pivot.uml.internal.oclforuml.OCLforUMLPackage;
import org.eclipse.ocl.pivot.uml.internal.resource.UMLASResourceFactory;
import org.eclipse.ocl.pivot.utilities.PivotStandaloneSetup;
import org.eclipse.uml2.uml.UMLPlugin;

public class UMLStandaloneSetup {
    public static final @NonNull String PROFILES_PATHMAP = "pathmap://OCL_PROFILES/";
    public static final @NonNull String OCL4UML_PROFILE_URI = "pathmap://OCL_PROFILES/OCLforUML.profile.uml#_0";
    private static boolean initialized = false;
    private static final Logger logger = Logger.getLogger(UMLStandaloneSetup.class);

    public static void assertInitialized() {
        if (!initialized && !EMFPlugin.IS_ECLIPSE_RUNNING) {
            logger.warn((Object)"UMLStandaloneSetup.init() should be called before using OCL's UML facilities");
            UMLStandaloneSetup.init();
        }
    }

    private static URI getBaseOCLResourceURI() {
        URI result;
        URI umlMetamodel = URI.createURI((String)OCL4UML_PROFILE_URI).trimFragment();
        String jarResourceName = String.format("model/%s", umlMetamodel.lastSegment());
        URL resultURL = UMLStandaloneSetup.class.getClassLoader().getResource(jarResourceName);
        if (resultURL != null) {
            result = URI.createURI((String)resultURL.toExternalForm(), (boolean)true).trimSegments(2);
        } else {
            Class<UMLStandaloneSetup> exampleClass = UMLStandaloneSetup.class;
            resultURL = exampleClass.getResource(String.valueOf(exampleClass.getSimpleName()) + ".class");
            String baseURL = resultURL.toExternalForm();
            baseURL = baseURL.substring(0, baseURL.lastIndexOf("/bin/"));
            result = URI.createURI((String)baseURL, (boolean)true);
        }
        return result;
    }

    public static void init() {
        if (!initialized) {
            initialized = true;
            PivotStandaloneSetup.init();
            UMLASResourceFactory.getInstance();
            UML2AS.initialize();
            UML2AS.initializeUMLglobals();
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/2015/OCLforUML/1", (Object)OCLforUMLPackage.eINSTANCE);
            URI ocl4umlProfileURI = URI.createURI((String)OCL4UML_PROFILE_URI);
            UMLPlugin.getEPackageNsURIToProfileLocationMap().put("http://www.eclipse.org/ocl/2015/OCLforUML/1", ocl4umlProfileURI);
            URI baseURI = UMLStandaloneSetup.getBaseOCLResourceURI();
            UMLStandaloneSetup.mapUMLResourceURIs(URIConverter.URI_MAP, PROFILES_PATHMAP, baseURI.appendSegment("model"));
            UMLStandaloneSetup.initializeLabelGenerators(ILabelGenerator.Registry.INSTANCE);
        }
    }

    public static void initializeLabelGenerators(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ILabelGenerator.Registry labelRegistry) {
        CommentLabelGenerator.initialize(labelRegistry);
        LiteralBooleanLabelGenerator.initialize(labelRegistry);
        LiteralIntegerLabelGenerator.initialize(labelRegistry);
        LiteralNullLabelGenerator.initialize(labelRegistry);
        LiteralRealLabelGenerator.initialize(labelRegistry);
        LiteralStringLabelGenerator.initialize(labelRegistry);
        LiteralUnlimitedNaturalLabelGenerator.initialize(labelRegistry);
        NamedElementLabelGenerator.initialize(labelRegistry);
        OpaqueExpressionLabelGenerator.initialize(labelRegistry);
        PackageImportLabelGenerator.initialize(labelRegistry);
        SlotLabelGenerator.initialize(labelRegistry);
        UMLElementExtensionLabelGenerator.initialize(labelRegistry);
    }

    private static void mapUMLResourceURIs(Map<URI, URI> uriMap, String uri, URI location) {
        URI prefix = URI.createURI((String)uri);
        if (!prefix.hasTrailingPathSeparator()) {
            prefix = prefix.appendSegment("");
        }
        if (!location.hasTrailingPathSeparator()) {
            location = location.appendSegment("");
        }
        uriMap.put(prefix, location);
        String folder = location.segment(location.segmentCount() - 2);
        String platformURI = String.format("%s/%s/", "org.eclipse.ocl.pivot.uml", folder);
        uriMap.put(URI.createPlatformPluginURI((String)platformURI, (boolean)true), location);
        uriMap.put(URI.createPlatformResourceURI((String)platformURI, (boolean)true), location);
    }
}

