/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCaseWithAutoTearDown;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.internal.utilities.PivotDiagnostician;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.internal.validation.UMLOCLEValidator;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class AbstractValidateTests
extends PivotTestCaseWithAutoTearDown {
    public static final @NonNull String VIOLATED_TEMPLATE = "The ''{0}'' constraint is violated on ''{1}''";

    public static @NonNull List<Diagnostic> assertUMLOCLValidationDiagnostics(@Nullable OCL ocl, @NonNull String prefix, @NonNull Resource resource, String ... messages) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        if (ocl != null) {
            PivotDiagnostician.setOCL((Map)validationContext, (OCL)ocl);
        }
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (EObject eObject : resource.getContents()) {
            EValidatorRegistryImpl registry = new EValidatorRegistryImpl();
            registry.put((Object)UMLPackage.eINSTANCE, (Object)UMLOCLEValidator.INSTANCE);
            Diagnostician dignostician = new Diagnostician((EValidator.Registry)registry);
            Diagnostic diagnostic = dignostician.validate(eObject, validationContext);
            diagnostics.addAll(diagnostic.getChildren());
        }
        return AbstractValidateTests.assertDiagnostics(prefix, resource, diagnostics, messages);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void checkValidationDiagnostics(@NonNull EObject testInstance, int severity, String ... expectedMessage) {
        @NonNull BagImpl expectedMessages = new BagImpl();
        String[] stringArray = expectedMessage;
        int n = expectedMessage.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            expectedMessages.add((Object)message);
            ++n2;
        }
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        BasicDiagnostic diagnostics = PivotDiagnostician.BasicDiagnosticWithRemove.validate((EObject)testInstance, (Map)validationContext);
        BagImpl actualMessages = new BagImpl();
        for (Diagnostic diagnostic : diagnostics.getChildren()) {
            actualMessages.add((Object)diagnostic.getMessage());
        }
        String s = AbstractValidateTests.formatMessageDifferences((Bag<String>)expectedMessages, (Bag<String>)actualMessages);
        if (s != null) {
            AbstractValidateTests.fail((String)("Inconsistent validation: (expected/actual) message" + s));
        }
    }

    protected @NonNull OCL createOCL() {
        OCL ocl = OCL.newInstance((ProjectManager)AbstractValidateTests.getProjectMap());
        return ocl;
    }

    public @NonNull Resource doLoadOCLinEcore(@NonNull OCL ocl, @NonNull URI inputURI) throws IOException {
        String lastSegment = inputURI.trimFileExtension().appendFileExtension("ecore").lastSegment();
        assert (lastSegment != null);
        URI ecoreURI = this.getTestFileURI(lastSegment);
        return this.doLoadOCLinEcore(ocl, inputURI, ecoreURI);
    }

    public @NonNull Resource doLoadOCLinEcore(@NonNull OCL ocl, @NonNull URI inputURI, @NonNull URI ecoreURI) throws IOException {
        CSResource xtextResource = ocl.getCSResource(inputURI);
        AbstractValidateTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        ASResource asResource = ocl.cs2as(xtextResource);
        AbstractValidateTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
        AbstractValidateTests.assertNoValidationErrors("Pivot validation errors", (EObject)asResource.getModel());
        Resource ecoreResource = AbstractValidateTests.as2ecore(ocl, (Resource)asResource, ecoreURI, NO_MESSAGES);
        return ecoreResource;
    }

    public Resource doLoadUML(@NonNull OCL ocl, @NonNull URI umlURI) throws IOException {
        return ocl.getResourceSet().getResource(umlURI, true);
    }

    public @NonNull List<Diagnostic> doValidateOCLinEcore(OCL ocl, String stem, @NonNull String @NonNull [] validationDiagnostics) throws IOException {
        String inputName = String.valueOf(stem) + ".oclinecore";
        URI inputURI = this.getTestFileURI(inputName);
        BaseCSResource xtextResource = (BaseCSResource)ocl.getResourceSet().createResource(inputURI);
        assert (xtextResource != null);
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        InputStream inputStream = ocl.getResourceSet().getURIConverter().createInputStream(inputURI);
        xtextResource.load(inputStream, null);
        AbstractValidateTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        ASResource asResource = ocl.cs2as((CSResource)xtextResource);
        AbstractValidateTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
        return AbstractValidateTests.assertValidationDiagnostics("Pivot validation errors", (Resource)asResource, validationDiagnostics);
    }

    protected @NonNull EObject eCreate(@NonNull EPackage ePackage, @NonNull String className) {
        EClass eClass = (EClass)ePackage.getEClassifier(className);
        EFactory eFactoryInstance = ePackage.getEFactoryInstance();
        return eFactoryInstance.create(eClass);
    }

    protected void eSet(@NonNull EObject eObject, @NonNull String eFeatureName, Object value) {
        EClass eClass = eObject.eClass();
        EStructuralFeature eFeature = eClass.getEStructuralFeature(eFeatureName);
        assert (eFeature != null);
        eObject.eSet(eFeature, value);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestCaseAppender.INSTANCE.install();
        TestUtil.doCompleteOCLSetup();
        TestUtil.doOCLinEcoreSetup();
        TestUtil.doOCLstdlibSetup();
    }

    @Override
    protected void tearDown() throws Exception {
        GlobalEnvironmentFactory.disposeInstance();
        super.tearDown();
    }
}

