/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.XMIResourceWithSize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCloner {
    public static List<Resource> createResourceClones(Resource resourceToClone, int amountOfClones) {
        ArrayList<Resource> cloneList = new ArrayList<Resource>(amountOfClones);
        int i = 0;
        while (i < amountOfClones) {
            cloneList.add(ModelCloner.cloneResource(resourceToClone, String.valueOf(i)));
            ++i;
        }
        assert (cloneList.size() == amountOfClones);
        return cloneList;
    }

    public static Resource cloneResource(Resource resourceToClone, String cloneId) {
        Object clone;
        URI uri = resourceToClone.getURI();
        String ext = uri.fileExtension();
        String name = "";
        name = String.valueOf(uri.trimFileExtension().lastSegment()) + "." + cloneId;
        uri = URI.createURI((String)name).resolve(uri).appendFileExtension(ext);
        ResourceSetImpl resultRS = new ResourceSetImpl();
        resultRS.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        ECrossReferenceAdapter adapter = new ECrossReferenceAdapter();
        resultRS.eAdapters().add((Object)adapter);
        if (resourceToClone instanceof XMIResourceWithSize) {
            clone = new XMIResourceWithSize(uri, (XMIResourceWithSize)resourceToClone);
            resultRS.getResources().add(clone);
        } else {
            clone = resultRS.createResource(uri);
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        clone.getContents().addAll(copier.copyAll((Collection)resourceToClone.getContents()));
        copier.copyReferences();
        clone = ModelCloner.cloneXMLResourceIDs(resourceToClone, clone);
        return clone;
    }

    private static Resource cloneXMLResourceIDs(Resource resourceToClone, Resource clone) {
        if (resourceToClone instanceof XMLResource) {
            TreeIterator iterator = resourceToClone.getAllContents();
            TreeIterator cloneIterator = clone.getAllContents();
            while (iterator.hasNext()) {
                EObject next = (EObject)iterator.next();
                EObject nextClone = (EObject)cloneIterator.next();
                if (next.eClass() != nextClone.eClass()) {
                    throw new RuntimeException("Something went wrong with the iteration order between original and clone");
                }
                ((XMLResource)clone).setID(nextClone, ((XMLResource)resourceToClone).getID(next));
            }
        } else {
            System.out.println("Not XML Resource");
        }
        return clone;
    }
}

