/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import prefuse.data.io.sql.DatabaseDataSource;
import prefuse.data.io.sql.DefaultSQLDataHandler;
import prefuse.data.io.sql.SQLDataHandler;

public class ConnectionFactory {
    public static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    public static final String DRIVER_JDBC_OBDC = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String PROTOCOL_JDBC = "jdbc:";
    public static final String SUBPROTOCOL_MYSQL = "mysql:";
    public static final String SUBPROTOCOL_JDBC_ODBC = "odbc:";

    public static SQLDataHandler getDefaultHandler() {
        return new DefaultSQLDataHandler();
    }

    public static DatabaseDataSource getDatabaseConnection(Connection conn, SQLDataHandler handler) throws SQLException {
        return new DatabaseDataSource(conn, handler);
    }

    public static DatabaseDataSource getDatabaseConnection(Connection conn) throws SQLException {
        return ConnectionFactory.getDatabaseConnection(conn, ConnectionFactory.getDefaultHandler());
    }

    public static DatabaseDataSource getDatabaseConnection(String driver, String url, String user, String password, SQLDataHandler handler) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        Connection conn = DriverManager.getConnection(url, user, password);
        return ConnectionFactory.getDatabaseConnection(conn, handler);
    }

    public static DatabaseDataSource getDatabaseConnection(String driver, String url, String user, String password) throws SQLException, ClassNotFoundException {
        return ConnectionFactory.getDatabaseConnection(driver, url, user, password, ConnectionFactory.getDefaultHandler());
    }

    public static DatabaseDataSource getMySQLConnection(String host, String database, String user, String password, SQLDataHandler handler) throws SQLException, ClassNotFoundException {
        String url = "jdbc:mysql://" + host + "/" + database;
        return ConnectionFactory.getDatabaseConnection(DRIVER_MYSQL, url, user, password, handler);
    }

    public static DatabaseDataSource getMySQLConnection(String host, String database, String user, String password) throws SQLException, ClassNotFoundException {
        return ConnectionFactory.getMySQLConnection(host, database, user, password, ConnectionFactory.getDefaultHandler());
    }
}

