/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.internal.TranslateJavaModelToKdm;
import org.eclipse.modisco.java.emf.JavaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverKDMModelFromEMFResources
extends AbstractModelDiscoverer<Resource> {
    public static final String ID = "org.eclipse.modisco.java.discoverer.javaResourceToKDM";
    private String pathToTransfo = null;

    @Parameter(name="PATH_TO_TRANSFORMATION", description="Indicates which .asm file to use for the ATL transformation (specified as a java URL)")
    public void setPathToTransfo(String pathToTransfo) {
        this.pathToTransfo = pathToTransfo;
    }

    public boolean isApplicableTo(Resource resource) {
        boolean result = false;
        EList contents = resource.getContents();
        if (!contents.isEmpty()) {
            EObject eObject = (EObject)contents.get(0);
            EPackage ePackage = eObject.eClass().getEPackage();
            result = ePackage == JavaPackage.eINSTANCE;
        }
        return result;
    }

    protected void basicDiscoverElement(Resource inputResource, IProgressMonitor monitor) throws DiscoveryException {
        try {
            TranslateJavaModelToKdm kdmTranslater = new TranslateJavaModelToKdm();
            if (this.pathToTransfo != null) {
                kdmTranslater.setPathToTransformation(this.pathToTransfo);
            }
            URI javaModelURI = inputResource.getURI();
            URI kdmModelUri = javaModelURI.appendSegment("_kdm.xmi");
            this.setDefaultTargetURI(kdmModelUri);
            Resource kdmResource = kdmTranslater.getKDMModelFromJavaModelWithCustomTransformation(javaModelURI, inputResource, kdmModelUri);
            this.getResourceSet().getResources().add((Object)kdmResource);
            this.setTargetModel(kdmResource);
        }
        catch (Exception e) {
            throw new DiscoveryException("Error discovering KDM model", (Throwable)e);
        }
    }
}

