/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import java.util.List;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.Helpers;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.expr.LiteralExpression;
import org.eclipse.xtend.backend.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwitchExpression
extends ExpressionBase {
    private final ExpressionBase _switchExpr;
    private final List<Pair<ExpressionBase, ExpressionBase>> _cases;
    private final ExpressionBase _defaultExpr;

    public SwitchExpression(ExpressionBase switchExpr, List<Pair<ExpressionBase, ExpressionBase>> cases, ExpressionBase defaultExpr, SourcePos sourcePos) {
        super(sourcePos);
        if (switchExpr == null) {
            switchExpr = new LiteralExpression(Boolean.TRUE, sourcePos);
        }
        this._switchExpr = switchExpr;
        this._cases = cases;
        this._defaultExpr = defaultExpr;
    }

    public ExpressionBase getSwitchExpr() {
        return this._switchExpr;
    }

    public List<Pair<ExpressionBase, ExpressionBase>> getCases() {
        return this._cases;
    }

    public ExpressionBase getDefaultExpr() {
        return this._defaultExpr;
    }

    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        Object switchVal = this._switchExpr.evaluate(ctx);
        for (Pair<ExpressionBase, ExpressionBase> curCase : this._cases) {
            Object curVal = curCase.getFirst().evaluate(ctx);
            if (!Helpers.nullSafeEquals(ctx, switchVal, curVal)) continue;
            return curCase.getSecond().evaluate(ctx);
        }
        return this._defaultExpr.evaluate(ctx);
    }
}

