/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.search;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.internal.xpand2.XpandUtil;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.AbstractXpandVisitor;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ErrorStatement;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.ExpressionStatement;
import org.eclipse.internal.xpand2.ast.FileStatement;
import org.eclipse.internal.xpand2.ast.ForEachStatement;
import org.eclipse.internal.xpand2.ast.IfStatement;
import org.eclipse.internal.xpand2.ast.LetStatement;
import org.eclipse.internal.xpand2.ast.ProtectStatement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.internal.xtend.expression.ast.AbstractExpressionVisitor;
import org.eclipse.internal.xtend.expression.ast.AbstractVisitor;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.OperationCall;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.ast.AbstractExtension;
import org.eclipse.internal.xtend.xtend.ast.AbstractExtensionDefinition;
import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.Check;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.search.SearchMatch;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendXpandSearchEngine {
    public static List<Definition> findAllDefines(IXtendXpandProject project) {
        IXtendXpandResource[] resources;
        ArrayList<Definition> matches = new ArrayList<Definition>();
        IXtendXpandResource[] iXtendXpandResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandResource res = iXtendXpandResourceArray[n2];
            if (res.getExtXptResource() instanceof Template) {
                Template tpl = (Template)res.getExtXptResource();
                XpandDefinition[] xpandDefinitionArray = tpl.getDefinitions();
                int n3 = xpandDefinitionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    XpandDefinition xdef = xpandDefinitionArray[n4];
                    if (xdef instanceof Definition) {
                        Definition def = (Definition)xdef;
                        matches.add(def);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return matches;
    }

    public static List<SearchMatch> findAllOccurrences(IXtendXpandProject project, String identifier) {
        IXtendXpandResource[] resources;
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
        IXtendXpandResource[] iXtendXpandResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandResource res = iXtendXpandResourceArray[n2];
            if (res.getExtXptResource() instanceof Template) {
                Template tpl = (Template)res.getExtXptResource();
                XpandDefinition[] xpandDefinitionArray = tpl.getDefinitions();
                int n3 = xpandDefinitionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Definition def;
                    XpandDefinition xdef = xpandDefinitionArray[n4];
                    if (xdef instanceof Definition && (def = (Definition)xdef).getName().equals(identifier)) {
                        int startOfDefnitionName = def.getDefName().getStart() - 1;
                        int lengthOfDefinitionName = def.getDefName().getEnd() - def.getDefName().getStart();
                        matches.add(new SearchMatch(startOfDefnitionName, lengthOfDefinitionName, res.getUnderlyingStorage()));
                    }
                    ++n4;
                }
            }
            Set<ExpandStatement> ops = XtendXpandSearchEngine.findRec(res.getExtXptResource(), ExpandStatement.class, new HashSet<Object>());
            for (ExpandStatement expr : ops) {
                Identifier definition = expr.getDefinition();
                String definitionFQN = definition.getValue();
                int lastIndexOf = definitionFQN.lastIndexOf(identifier);
                if (lastIndexOf <= -1) continue;
                int startOfDefinition = definition.getStart() + lastIndexOf - 1;
                int lengthOfDefinition = identifier.length();
                matches.add(new SearchMatch(startOfDefinition, lengthOfDefinition, res.getUnderlyingStorage()));
            }
            ++n2;
        }
        iXtendXpandResourceArray = project.getProject().getProject().getReferencingProjects();
        n = iXtendXpandResourceArray.length;
        n2 = 0;
        while (n2 < n) {
            IXtendXpandResource p = iXtendXpandResourceArray[n2];
            IXtendXpandProject extxptp = Activator.getExtXptModelManager().findProject((IResource)p);
            if (extxptp != null) {
                matches.addAll(XtendXpandSearchEngine.findAllOccurrences(extxptp, identifier));
            }
            ++n2;
        }
        return XtendXpandSearchEngine.sort(matches);
    }

    public static List<SearchMatch> findReferences(IXtendXpandProject project, String identifier) {
        IXtendXpandResource[] resources;
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
        IXtendXpandResource[] iXtendXpandResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandResource res = iXtendXpandResourceArray[n2];
            Set<OperationCall> ops = XtendXpandSearchEngine.findRec(res.getExtXptResource(), OperationCall.class, new HashSet<Object>());
            for (OperationCall expr : ops) {
                if (!expr.getName().getValue().equals(identifier)) continue;
                matches.add(new SearchMatch(expr.getName().getStart() + 1, expr.getName().getEnd() - expr.getStart(), res.getUnderlyingStorage()));
            }
            ++n2;
        }
        iXtendXpandResourceArray = project.getProject().getProject().getReferencingProjects();
        n = iXtendXpandResourceArray.length;
        n2 = 0;
        while (n2 < n) {
            IXtendXpandResource p = iXtendXpandResourceArray[n2];
            IXtendXpandProject extxptp = Activator.getExtXptModelManager().findProject((IResource)p);
            if (extxptp != null) {
                matches.addAll(XtendXpandSearchEngine.findReferences(extxptp, identifier));
            }
            ++n2;
        }
        return XtendXpandSearchEngine.sort(matches);
    }

    public static List<SearchMatch> findDeclarations(IXtendXpandProject project, String identifier) {
        IXtendXpandResource[] resources;
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
        IXtendXpandResource[] iXtendXpandResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandResource res = iXtendXpandResourceArray[n2];
            if (res.getExtXptResource() instanceof ExtensionFile) {
                ExtensionFile ef = (ExtensionFile)res.getExtXptResource();
                for (Extension ext : ef.getExtensions()) {
                    if (!(ext instanceof AbstractExtension)) continue;
                    AbstractExtension ae = (AbstractExtension)ext;
                    if (!ext.getName().equals(identifier)) continue;
                    Identifier id = ae.getNameIdentifier();
                    matches.add(new SearchMatch(id.getStart() + 1, id.getEnd() - id.getStart() + 1, res.getUnderlyingStorage()));
                }
            }
            if (res.getExtXptResource() instanceof Template) {
                Template tpl = (Template)res.getExtXptResource();
                XpandDefinition[] xpandDefinitionArray = tpl.getDefinitions();
                int n3 = xpandDefinitionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Definition def;
                    XpandDefinition xdef = xpandDefinitionArray[n4];
                    if (xdef instanceof Definition && (def = (Definition)xdef).getName().equals(identifier)) {
                        matches.add(new SearchMatch(def.getDefName().getStart(), def.getDefName().getEnd() - def.getDefName().getStart(), res.getUnderlyingStorage()));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        try {
            iXtendXpandResourceArray = project.getProject().getProject().getReferencedProjects();
            n = iXtendXpandResourceArray.length;
            n2 = 0;
            while (n2 < n) {
                IXtendXpandResource p = iXtendXpandResourceArray[n2];
                IXtendXpandProject extxptp = Activator.getExtXptModelManager().findProject((IResource)p);
                if (extxptp != null) {
                    matches.addAll(XtendXpandSearchEngine.findDeclarations(extxptp, identifier));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        return XtendXpandSearchEngine.sort(matches);
    }

    public static List<AbstractDefinition> findDefinitionsByNameInResourceAndImports(IXtendXpandProject project, String identifier, XpandResource resource) {
        int n;
        XpandResource xpandResource;
        ArrayList<AbstractDefinition> matches = new ArrayList<AbstractDefinition>();
        String definitionName = XpandUtil.getLastSegment((String)identifier);
        String templateName = XpandUtil.withoutLastSegment((String)identifier);
        XpandExecutionContext xctx = (XpandExecutionContext)Activator.getExecutionContext(project.getProject()).cloneWithResource((Resource)resource);
        ArrayList<XpandResource> tpls = new ArrayList<XpandResource>();
        if (templateName != null && !templateName.equals("") && (xpandResource = xctx.findTemplate(templateName)) != null) {
            tpls.add(xpandResource);
        }
        if (tpls.isEmpty()) {
            ArrayList<IXtendXpandResource> xtendXpandResources = new ArrayList<IXtendXpandResource>();
            String[] stringArray = resource.getImportedNamespaces();
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                xtendXpandResources.add(Activator.getExtXptModelManager().findXtendXpandResource(name.replaceAll("::", "/"), "xpt"));
                ++n2;
            }
            for (IXtendXpandResource res : xtendXpandResources) {
                if (res == null || !(res.getExtXptResource() instanceof XpandResource)) continue;
                tpls.add((XpandResource)res.getExtXptResource());
            }
            tpls.add(resource);
        }
        for (XpandResource tpl : tpls) {
            XpandDefinition[] xpandDefinitionArray = tpl.getDefinitions();
            int n3 = xpandDefinitionArray.length;
            n = 0;
            while (n < n3) {
                Definition def;
                XpandDefinition xdef = xpandDefinitionArray[n];
                if (xdef instanceof Definition && XpandUtil.getLastSegment((String)(def = (Definition)xdef).getName()).equals(definitionName)) {
                    matches.add((AbstractDefinition)def);
                }
                ++n;
            }
        }
        if (!matches.isEmpty()) {
            matches.add(matches.size(), (AbstractDefinition)matches.get(0));
            matches.remove(0);
        }
        return matches;
    }

    public static List<Extension> findExtensionsByNameInResourceAndImports(IXtendXpandProject project, String identifier, IXtendXpandResource resource) {
        ArrayList<Extension> matches = new ArrayList<Extension>();
        ExecutionContext ctx = Activator.getExecutionContext(project.getProject());
        ctx = ctx.cloneWithResource(resource.getExtXptResource());
        Set extensions = ctx.getAllExtensions();
        for (Extension ext : extensions) {
            if (!ext.getName().equals(identifier)) continue;
            matches.add(ext);
        }
        if (!matches.isEmpty()) {
            matches.add(matches.size(), (Extension)matches.get(0));
            matches.remove(0);
        }
        return matches;
    }

    private static List<SearchMatch> sort(List<SearchMatch> searchmatches) {
        Collections.sort(searchmatches, new Comparator<SearchMatch>(){

            @Override
            public int compare(SearchMatch o1, SearchMatch o2) {
                if (o1.getFile() == null) {
                    return -1;
                }
                if (o2.getFile() == null) {
                    return 1;
                }
                int fileCompare = o1.getFile().getName().compareTo(o2.getFile().getName());
                if (fileCompare == 0) {
                    return Integer.valueOf(o1.getOffSet()).compareTo(o2.getOffSet());
                }
                return fileCompare;
            }
        });
        return searchmatches;
    }

    private static <T extends SyntaxElement> Set<T> findRec(Object res, Class<T> clazz, Set<Object> visitedNodes) {
        Method[] methods;
        if (visitedNodes.contains(res)) {
            return Collections.emptySet();
        }
        visitedNodes.add(res);
        HashSet<Object> result = new HashSet<Object>();
        if (clazz.isInstance(res)) {
            result.add((SyntaxElement)res);
        }
        Class<?> instanceClass = res.getClass();
        Method[] methodArray = methods = instanceClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> pType;
            Method method = methodArray[n2];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && method.getName().startsWith("get") && method.getParameterTypes().length == 0 && (Collection.class.isAssignableFrom(pType = method.getReturnType()) || SyntaxElement.class.isAssignableFrom(pType))) {
                try {
                    Object invRes = method.invoke(res, new Object[0]);
                    if (invRes instanceof Collection) {
                        for (Object o : (Collection)invRes) {
                            result.addAll(XtendXpandSearchEngine.findRec(o, clazz, visitedNodes));
                        }
                    } else if (invRes != null) {
                        result.addAll(XtendXpandSearchEngine.findRec(invRes, clazz, visitedNodes));
                    }
                }
                catch (Exception e) {
                    XtendLog.logError(e);
                }
            }
            ++n2;
        }
        return result;
    }

    public static OperationCall findExpressionInTemplate(final IRegion region, Template template) {
        final HashSet targetStatement = new HashSet();
        AbstractDefinition[] defs = template.getAllDefinitions();
        XtendXpandSearchEngine xxse = new XtendXpandSearchEngine();
        AbstractDefinition[] abstractDefinitionArray = defs;
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDefinition def = abstractDefinitionArray[n2];
            if (!targetStatement.isEmpty()) break;
            def.accept((AbstractVisitor)new AbstractXpandVisitor(){

                protected Object visitExpressionStatement(ExpressionStatement node) {
                    if (node.getExpression() != null) {
                        Expression expression = node.getExpression();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    return node;
                }

                protected Object visitExpandStatement(ExpandStatement node) {
                    if (node.getTarget() != null) {
                        Expression expression = node.getTarget();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    if (node.getSeparator() != null) {
                        Expression expression = node.getSeparator();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    if (node.getParameters() != null) {
                        Expression[] expressionArray = node.getParameters();
                        int n = expressionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Expression param = expressionArray[n2];
                            XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                            xtendXpandSearchEngine.getClass();
                            param.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                            ++n2;
                        }
                    }
                    return node;
                }

                protected Object visitErrorStatement(ErrorStatement node) {
                    if (node.getMessage() != null) {
                        Expression expression = node.getMessage();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    return node;
                }

                protected Object visitFileStatement(FileStatement node) {
                    if (node.getTargetFileName() != null) {
                        Expression expression = node.getTargetFileName();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    this.visitChildren(node.getBodyAsList());
                    return node;
                }

                protected Object visitForEachStatement(ForEachStatement node) {
                    if (node.getTarget() != null) {
                        Expression expression = node.getTarget();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    if (node.getSeparator() != null) {
                        Expression expression = node.getSeparator();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    this.visitChildren(node.getBodyAsList());
                    return node;
                }

                protected Object visitIfStatement(IfStatement node) {
                    if (node.getCondition() != null) {
                        Expression expression = node.getCondition();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    this.visitChildren(node.getBodyAsList());
                    this.visitChild((SyntaxElement)node.getElseIf());
                    return node;
                }

                protected Object visitLetStatement(LetStatement node) {
                    if (node.getVarValue() != null) {
                        Expression expression = node.getVarValue();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    this.visitChildren(node.getBodyAsList());
                    return node;
                }

                protected Object visitProtectStatement(ProtectStatement node) {
                    if (node.getCommentStart() != null) {
                        Expression expression = node.getCommentStart();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    if (node.getCommentEnd() != null) {
                        Expression expression = node.getCommentEnd();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    if (node.getId() != null) {
                        Expression expression = node.getId();
                        XtendXpandSearchEngine xtendXpandSearchEngine = XtendXpandSearchEngine.this;
                        xtendXpandSearchEngine.getClass();
                        expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
                    }
                    this.visitChildren(node.getBodyAsList());
                    return node;
                }
            });
            if (!targetStatement.isEmpty()) {
                return (OperationCall)targetStatement.iterator().next();
            }
            ++n2;
        }
        return null;
    }

    public static OperationCall findExpressionInExtensionFile(IRegion region, ExtensionFile extensionFile) {
        HashSet<OperationCall> targetStatement = new HashSet<OperationCall>();
        XtendXpandSearchEngine xxse = new XtendXpandSearchEngine();
        for (Extension extension : extensionFile.getExtensions()) {
            if (!targetStatement.isEmpty()) break;
            if (!(extension instanceof AbstractExtensionDefinition) || extension.getStart() > region.getOffset() || extension.getEnd() < region.getOffset() + region.getLength()) continue;
            AbstractExtensionDefinition abstractExtensionDefinition = (AbstractExtensionDefinition)extension;
            Expression expression = abstractExtensionDefinition.getExpression();
            XtendXpandSearchEngine xtendXpandSearchEngine = xxse;
            xtendXpandSearchEngine.getClass();
            expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
        }
        for (Around around : extensionFile.getArounds()) {
            if (!targetStatement.isEmpty()) break;
            if (around.getStart() > region.getOffset() || around.getEnd() < region.getOffset() + region.getLength()) continue;
            Expression expression = around.getExpression();
            XtendXpandSearchEngine xtendXpandSearchEngine = xxse;
            xtendXpandSearchEngine.getClass();
            expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
        }
        for (Check check : extensionFile.getChecks()) {
            if (!targetStatement.isEmpty()) break;
            if (check.getStart() > region.getOffset() || check.getEnd() < region.getOffset() + region.getLength()) continue;
            Expression expression = check.getMsg();
            XtendXpandSearchEngine xtendXpandSearchEngine = xxse;
            xtendXpandSearchEngine.getClass();
            expression.accept((AbstractVisitor)xtendXpandSearchEngine.new ExpressionVisitor(region, targetStatement));
            Expression expression2 = check.getConstraint();
            XtendXpandSearchEngine xtendXpandSearchEngine2 = xxse;
            xtendXpandSearchEngine2.getClass();
            expression2.accept((AbstractVisitor)xtendXpandSearchEngine2.new ExpressionVisitor(region, targetStatement));
            if (check.getGuard() == null) continue;
            Expression expression3 = check.getGuard();
            XtendXpandSearchEngine xtendXpandSearchEngine3 = xxse;
            xtendXpandSearchEngine3.getClass();
            expression3.accept((AbstractVisitor)xtendXpandSearchEngine3.new ExpressionVisitor(region, targetStatement));
        }
        return targetStatement.isEmpty() ? null : (OperationCall)targetStatement.iterator().next();
    }

    public static ExpandStatement findDefinition(final String name, final IRegion region, Template template) {
        final HashSet targetStatement = new HashSet();
        AbstractDefinition[] abstractDefinitionArray = template.getAllDefinitions();
        int n = abstractDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDefinition def = abstractDefinitionArray[n2];
            if (!targetStatement.isEmpty()) break;
            def.accept((AbstractVisitor)new AbstractXpandVisitor(){

                protected Object visitExpandStatement(ExpandStatement node) {
                    if (node.getStart() <= region.getOffset() && node.getEnd() >= region.getOffset() + region.getLength() && node.getDefinition().getValue().contains(name.trim())) {
                        targetStatement.add(node);
                    }
                    return super.visitExpandStatement(node);
                }
            });
            if (!targetStatement.isEmpty()) {
                return (ExpandStatement)targetStatement.iterator().next();
            }
            ++n2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExpressionVisitor
    extends AbstractExpressionVisitor {
        public Set<OperationCall> targetStatement = new HashSet<OperationCall>();
        private final IRegion region;

        public ExpressionVisitor(IRegion region, Set<OperationCall> targetStatement) {
            this.region = region;
            this.targetStatement = targetStatement;
        }

        protected Object visitOperationCall(OperationCall oc) {
            if (oc.getStart() <= this.region.getOffset() && oc.getEnd() >= this.region.getOffset() + this.region.getLength()) {
                this.targetStatement.add(oc);
            }
            if (oc.getTarget() != null) {
                oc.getTarget().accept((AbstractVisitor)this);
            }
            if (oc.getParamsAsList() != null) {
                for (Expression expr : oc.getParamsAsList()) {
                    expr.accept((AbstractVisitor)this);
                }
            }
            return oc;
        }
    }
}

