/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.search.view;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.xtend.shared.ui.editor.search.query.XtendXpandSearchResult;
import org.eclipse.xtend.shared.ui.editor.search.view.IFileSearchContentProvider;
import org.eclipse.xtend.shared.ui.editor.search.view.XtendXpandSearchResultPage;

public class XtendXpandTableContentProvider
implements IStructuredContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private final XtendXpandSearchResultPage page;
    private AbstractTextSearchResult result;

    public XtendXpandTableContentProvider(XtendXpandSearchResultPage page) {
        this.page = page;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof XtendXpandSearchResult) {
            int elementLimit = 1000;
            Object[] elements = ((XtendXpandSearchResult)((Object)inputElement)).getElements();
            if (elementLimit != -1 && elements.length > elementLimit) {
                Object[] shownElements = new Object[elementLimit];
                System.arraycopy(elements, 0, shownElements, 0, elementLimit);
                return shownElements;
            }
            return elements;
        }
        return this.EMPTY_ARR;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof XtendXpandSearchResult) {
            this.result = (XtendXpandSearchResult)((Object)newInput);
        }
    }

    public void elementsChanged(Object[] updatedElements) {
        TableViewer viewer = this.getViewer();
        int elementLimit = 1000;
        boolean tableLimited = elementLimit != -1;
        Object[] objectArray = updatedElements;
        int n = updatedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.result.getMatchCount(element) > 0) {
                if (viewer.testFindItem(element) != null) {
                    viewer.update(element, null);
                } else if (!tableLimited || viewer.getTable().getItemCount() < elementLimit) {
                    viewer.add(element);
                }
            } else {
                viewer.remove(element);
            }
            ++n2;
        }
    }

    private TableViewer getViewer() {
        return (TableViewer)this.page.getViewer();
    }

    public void clear() {
        this.getViewer().refresh();
    }

    public void dispose() {
    }
}

