/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend;

import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.internal.xtend.xtend.ast.ExtensionImportStatement;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.plugins.ImportedResource;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEnd;
import org.eclipse.xtend.middleend.plugins.ParsedResource;
import org.eclipse.xtend.middleend.xtend.OldHelper;
import org.eclipse.xtend.middleend.xtend.internal.TypeToBackendType;
import org.eclipse.xtend.middleend.xtend.internal.xtend.CheckConverter;
import org.eclipse.xtend.middleend.xtend.internal.xtend.OldExtensionConverter;
import org.eclipse.xtend.middleend.xtend.internal.xtendlib.XtendLibContributor;

public final class OldXtendRegistry
implements LanguageSpecificMiddleEnd {
    private final ExecutionContext _ctx;
    private MiddleEnd _middleEnd;
    private BackendTypesystem _ts;

    public OldXtendRegistry(Object specificData) {
        if (specificData == null) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " middle end is not initialized - will not contribute");
        }
        this._ctx = (ExecutionContext)specificData;
    }

    public void setMiddleEnd(MiddleEnd middleEnd) {
        this._middleEnd = middleEnd;
        this._ts = middleEnd.getTypesystem();
    }

    public boolean canHandle(String resourceName) {
        resourceName = OldHelper.normalizeXtendResourceName(resourceName);
        try {
            ExtensionFile extensionFile = (ExtensionFile)this._ctx.getResourceManager().loadResource(resourceName, "ext");
            return extensionFile != null;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public boolean mayHandle(String resourceName) {
        return resourceName.endsWith("ext");
    }

    public String getName() {
        return "Xtend";
    }

    public ParsedResource parseResource(String xtendFile) {
        ParsedResource result = new ParsedResource();
        xtendFile = OldHelper.normalizeXtendResourceName(xtendFile);
        ExtensionFile extensionFile = (ExtensionFile)this._ctx.getResourceManager().loadResource(xtendFile, "ext");
        if (extensionFile == null) {
            throw new IllegalArgumentException("could not find extension '" + xtendFile + "'");
        }
        ExecutionContext ctx = this._ctx.cloneWithResource((Resource)extensionFile);
        TypeToBackendType typeConverter = new TypeToBackendType(this._ts, ctx);
        OldExtensionConverter extensionFactory = new OldExtensionConverter(ctx, typeConverter);
        for (Extension ext : extensionFile.getExtensions()) {
            ext.init(ctx);
        }
        this.registerXtendLib(result);
        result.getPrivateFunctions().add(new CheckConverter(ctx, typeConverter).createCheckFunction(this._ts, extensionFile));
        for (Extension ext : extensionFile.getExtensions()) {
            NamedFunction f = extensionFactory.createUnregistered(ext);
            if (ext.isPrivate()) {
                result.getPrivateFunctions().add(f);
                continue;
            }
            result.getPublicFunctions().add(f);
        }
        for (ExtensionImportStatement imp : extensionFile.getExtImports()) {
            result.getImports().add(new ImportedResource(OldHelper.normalizeXtendResourceName(imp.getImportedId().toString()), imp.isExported()));
        }
        for (Around a : extensionFile.getArounds()) {
            result.getAdvice().add(extensionFactory.create(a));
        }
        return result;
    }

    private void registerXtendLib(ParsedResource result) {
        XtendLibContributor xtendLibContrib = new XtendLibContributor(this._middleEnd);
        for (String contrib : xtendLibContrib.getContributingResources()) {
            result.getImports().add(new ImportedResource(contrib, false));
        }
        result.getPrivateFunctions().addAll(new XtendLibContributor(this._middleEnd).getContributedFunctions());
    }
}

