/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.functions.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.functions.DuplicateAwareFunctionCollection;
import org.eclipse.xtend.backend.functions.DuplicateAwareNamedFunctionCollection;
import org.eclipse.xtend.backend.functions.FunctionDefContextInternal;
import org.eclipse.xtend.backend.functions.SourceDefinedFunction;
import org.eclipse.xtend.backend.functions.internal.PolymorphicResolver;
import org.eclipse.xtend.backend.util.Cache;
import org.eclipse.xtend.backend.util.CollectionHelper;
import org.eclipse.xtend.backend.util.DoubleKeyCache;
import org.eclipse.xtend.backend.util.ErrorHandler;
import org.eclipse.xtend.backend.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionDefContextImpl
implements FunctionDefContextInternal {
    private final Cache<BackendType, Collection<NamedFunction>> _byFirstParameterType = new Cache<BackendType, Collection<NamedFunction>>(){

        @Override
        protected Collection<NamedFunction> create(BackendType key) {
            return new ArrayList<NamedFunction>();
        }
    };
    private final DoubleKeyCache<QualifiedName, Integer, DuplicateAwareNamedFunctionCollection> _functions = new DoubleKeyCache<QualifiedName, Integer, DuplicateAwareNamedFunctionCollection>(){

        @Override
        protected DuplicateAwareNamedFunctionCollection create(QualifiedName key1, Integer key2) {
            return new DuplicateAwareNamedFunctionCollection();
        }
    };
    private final DoubleKeyCache<QualifiedName, Integer, DuplicateAwareNamedFunctionCollection> _bySimpleName = new DoubleKeyCache<QualifiedName, Integer, DuplicateAwareNamedFunctionCollection>(){

        @Override
        protected DuplicateAwareNamedFunctionCollection create(QualifiedName key1, Integer key2) {
            return new DuplicateAwareNamedFunctionCollection();
        }
    };
    private final DoubleKeyCache<QualifiedName, List<BackendType>, Collection<Function>> _byParamTypes = new DoubleKeyCache<QualifiedName, List<BackendType>, Collection<Function>>(){

        @Override
        protected Collection<Function> create(QualifiedName functionName, List<BackendType> paramTypes) {
            return new PolymorphicResolver(functionName).getBestFitCandidates(this.findCandidates(functionName, paramTypes));
        }

        private Collection<Function> findCandidates(QualifiedName functionName, List<BackendType> paramTypes) {
            int paramCount = paramTypes.size();
            BackendType firstParamType = paramTypes.isEmpty() ? null : paramTypes.get(0);
            DuplicateAwareFunctionCollection result = new DuplicateAwareFunctionCollection();
            if (firstParamType != null) {
                for (NamedFunction namedFunction : firstParamType.getBuiltinOperations()) {
                    if (!functionName.equals(namedFunction.getName()) || !this.matchesParamTypes(namedFunction.getFunction(), paramTypes)) continue;
                    result.register(namedFunction.getFunction());
                }
            }
            if (functionName.getNameSpace() == null) {
                for (NamedFunction namedFunction : ((DuplicateAwareNamedFunctionCollection)FunctionDefContextImpl.this._bySimpleName.get(functionName, paramCount)).getFunctions()) {
                    if (!this.matchesParamTypes(namedFunction.getFunction(), paramTypes)) continue;
                    result.register(namedFunction.getFunction());
                }
            } else {
                for (NamedFunction namedFunction : ((DuplicateAwareNamedFunctionCollection)FunctionDefContextImpl.this._functions.get(functionName, paramCount)).getFunctions()) {
                    if (!this.matchesParamTypes(namedFunction.getFunction(), paramTypes)) continue;
                    result.register(namedFunction.getFunction());
                }
            }
            return result.getFunctions();
        }

        private boolean matchesParamTypes(Function f, List<BackendType> paramTypes) {
            if (f.getParameterTypes().size() != paramTypes.size()) {
                return false;
            }
            int i = 0;
            while (i < f.getParameterTypes().size()) {
                if (!f.getParameterTypes().get(i).isAssignableFrom(paramTypes.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    };
    private final DuplicateAwareNamedFunctionCollection _publicFunctions = new DuplicateAwareNamedFunctionCollection();

    @Override
    public void register(NamedFunction f, boolean isPublic) {
        if (isPublic) {
            this._publicFunctions.register(f);
        }
        QualifiedName simpleName = new QualifiedName(f.getName().getSimpleName());
        NamedFunction old = this._functions.get(f.getName(), f.getFunction().getParameterTypes().size()).register(f);
        NamedFunction simpleOld = this._bySimpleName.get(simpleName, f.getFunction().getParameterTypes().size()).register(f);
        if (old != null && old.getFunction().getParameterTypes().size() > 0) {
            this._byFirstParameterType.get(old.getFunction().getParameterTypes().get(0)).remove(old);
        }
        if (simpleOld != null && simpleOld.getFunction().getParameterTypes().size() > 0) {
            this._byFirstParameterType.get(simpleOld.getFunction().getParameterTypes().get(0)).remove(simpleOld);
        }
        if (f.getFunction().getParameterTypes().size() > 0) {
            this._byFirstParameterType.get(f.getFunction().getParameterTypes().get(0)).add(f);
        }
    }

    @Override
    public Object invoke(ExecutionContext ctx, QualifiedName functionName, List<? extends Object> params) {
        return this.invoke(ctx, functionName, params, false);
    }

    @Override
    public Object invoke(ExecutionContext ctx, QualifiedName functionName, List<? extends Object> params, boolean firstParamIsThis) {
        Collection<Function> candidates = this.findFunctionCandidates(functionName, this.typesForParameters(ctx.getTypesystem(), params), firstParamIsThis);
        Function f = null;
        try {
            f = new PolymorphicResolver(functionName).evaluateGuards(ctx, candidates);
        }
        catch (Exception exc) {
            ErrorHandler.handle("could not resolve function '" + functionName + "' for parameter types " + StringHelper.getTypesAsString(params) + " - candidates were " + candidates, exc);
        }
        QualifiedName name = null;
        name = f instanceof NamedFunction ? ((NamedFunction)((Object)f)).getName() : (f instanceof SourceDefinedFunction ? ((SourceDefinedFunction)f).getName() : functionName);
        if (firstParamIsThis && f.getParameterTypes().size() != params.size()) {
            return ctx.getAdviceContext().getAdvice(name, f).evaluate(ctx, CollectionHelper.withoutFirst(params));
        }
        return ctx.getAdviceContext().getAdvice(name, f).evaluate(ctx, params);
    }

    public List<BackendType> typesForParameters(BackendTypesystem ts, List<?> params) {
        ArrayList<BackendType> paramTypes = new ArrayList<BackendType>();
        for (Object o : params) {
            paramTypes.add(ts.findType(o));
        }
        return paramTypes;
    }

    public Collection<Function> findFunctionCandidates(QualifiedName functionName, List<BackendType> paramTypes, boolean firstParamIsThis) {
        try {
            Collection<Function> candidates = this._byParamTypes.get(functionName, paramTypes);
            if (candidates.isEmpty() && firstParamIsThis) {
                candidates = this._byParamTypes.get(functionName, CollectionHelper.withoutFirst(paramTypes));
            }
            return candidates;
        }
        catch (RuntimeException e) {
            ErrorHandler.handle("Failed to resolve function '" + functionName + "' for parameter types " + paramTypes + ".", e);
            return null;
        }
    }

    @Override
    public Collection<NamedFunction> getByFirstParameterType(BackendType firstParameterType) {
        if (firstParameterType.getBuiltinOperations().isEmpty()) {
            return this._byFirstParameterType.get(firstParameterType);
        }
        ArrayList<NamedFunction> result = new ArrayList<NamedFunction>(firstParameterType.getBuiltinOperations());
        result.addAll(this._byFirstParameterType.get(firstParameterType));
        return result;
    }

    @Override
    public Function getMatch(ExecutionContext ctx, QualifiedName name, List<BackendType> params) {
        Collection<Function> candidates = this.findFunctionCandidates(name, params, false);
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() > 1) {
            throw new IllegalArgumentException("several matches for function '" + name + "' and parameter types " + params + ".");
        }
        return candidates.iterator().next();
    }

    @Override
    public boolean hasMatch(ExecutionContext ctx, QualifiedName functionName, List<? extends Object> params) {
        return this.findFunctionCandidates(functionName, this.typesForParameters(ctx.getTypesystem(), params), false).size() > 0;
    }

    public String toString() {
        return "FunctionDefContextImpl [" + this._functions.getMap().values() + "]";
    }

    @Override
    public Collection<NamedFunction> getPublicFunctions() {
        return this._publicFunctions.getFunctions();
    }

    @Override
    public Collection<NamedFunction> getAllFunctions() {
        Collection<DuplicateAwareNamedFunctionCollection> values = this._functions.getMap().values();
        ArrayList<NamedFunction> functions = new ArrayList<NamedFunction>();
        for (DuplicateAwareNamedFunctionCollection v : values) {
            functions.addAll(v.getFunctions());
        }
        return functions;
    }
}

