/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.EcoreBuilder;
import org.eclipse.xtend.typesystem.xsd.builder.XSDManager;
import org.eclipse.xtend.typesystem.xsd.util.Msg;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OawEcoreBuilder
implements EcoreBuilder {
    protected Log log = XSDLog.getLog(this.getClass());
    private XSDManager xsdManager;

    public OawEcoreBuilder(XSDManager xsdManager) {
        this.xsdManager = xsdManager;
    }

    public Collection<? extends Resource> generate(Collection<URI> uris) throws Exception {
        for (URI u : uris) {
            this.xsdManager.loadAndGenerate(u);
        }
        return Collections.emptyList();
    }

    public Collection<? extends Resource> generate(Map<String, URI> targetNamespaceToURI) throws Exception {
        if (targetNamespaceToURI == null) {
            return Collections.emptyList();
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        EPackage.Registry reg = this.xsdManager.getPackageRegistry();
        for (Map.Entry<String, URI> e : targetNamespaceToURI.entrySet()) {
            if (reg.containsKey((Object)e.getKey())) {
                this.log.info((Object)("Already loaded EPackage requested. Namespace:" + e.getKey()));
                continue;
            }
            uris.add(e.getValue());
        }
        if (uris.size() > 0) {
            this.log.info((Object)Msg.create("Loading XSDSchema from ").uris(uris));
            this.generate(uris);
            for (String ns : targetNamespaceToURI.keySet()) {
                if (reg.containsKey((Object)ns)) continue;
                this.log.warn((Object)Msg.create("The requested namespace ").ns(ns).txt(" has not been loaded yet. ").txt("It was probably not found in ").uri(targetNamespaceToURI.get(ns)));
            }
        }
        return Collections.emptyList();
    }

    public Collection<? extends Resource> generate(URI uri) throws Exception {
        this.xsdManager.loadAndGenerate(uri);
        return Collections.emptyList();
    }

    public void setExtendedMetaData(ExtendedMetaData extendedMetaData) {
    }
}

