/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ui.core.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.internal.xtend.xtend.XtendFile;
import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionImportStatement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.shared.ui.core.AbstractResource;
import org.eclipse.xtend.shared.ui.core.internal.BuildState;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.ui.core.IXtendResource;
import org.eclipse.xtend.ui.core.internal.builder.XtendResourceParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendResourceImpl
extends AbstractResource
implements IXtendResource {
    private final XtendResourceParser parser;
    private final IProject project;

    @Deprecated
    public XtendResourceImpl(XtendFile tpl, IStorage res, XtendResourceParser parser) {
        this(tpl, null, res, parser);
    }

    public XtendResourceImpl(XtendFile tpl, IProject project, IStorage res, XtendResourceParser parser) {
        super(res);
        this.setExtXptResource((Resource)tpl);
        this.parser = parser;
        this.project = project;
    }

    private XtendFile resource() {
        return (XtendFile)this.getExtXptResource();
    }

    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        HashSet issuesFromThisResource = new HashSet();
        try {
            BuildState buildState = BuildState.get((ExecutionContext)ctx);
            if (buildState != null) {
                ResourceID id = new ResourceID(this.resource().getFullyQualifiedName(), this.getFileExtension());
                HashSet internalIssues = (HashSet)buildState.getIssuesPerResource().get(id);
                if (internalIssues == null) {
                    internalIssues = new HashSet();
                    this.resource().analyze(ctx, internalIssues);
                    buildState.getIssuesPerResource().put(id, internalIssues);
                }
                issuesFromThisResource.addAll(internalIssues);
            } else {
                this.resource().analyze(ctx, issuesFromThisResource);
            }
        }
        catch (Exception buildState) {
            // empty catch block
        }
        HashSet<AnalysationIssue> issuesToRemove = new HashSet<AnalysationIssue>();
        for (AnalysationIssue issue : issuesFromThisResource) {
            if (!issue.getType().equals(AnalysationIssue.RESOURCE_NOT_FOUND)) continue;
            ExtensionImportStatement importStmt = (ExtensionImportStatement)issue.getElement();
            for (AnalysationIssue issue2 : issuesFromThisResource) {
                if (!issue2.getType().equals(AnalysationIssue.INTERNAL_ERROR) || !issue2.getMessage().matches("Error parsing extensions.*" + importStmt.getImportedId() + "$")) continue;
                issuesToRemove.add(issue2);
            }
        }
        issuesFromThisResource.removeAll(issuesToRemove);
        issues.addAll(issuesFromThisResource);
    }

    public List<Extension> getExtensions() {
        return this.resource().getExtensions();
    }

    public List<Extension> getPublicExtensions(ResourceManager rm, ExecutionContext ctx) {
        return this.resource().getPublicExtensions(rm, ctx);
    }

    public List<Extension> getPublicExtensions(ResourceManager resourceManager, ExecutionContext ctx, Set<String> flowoverCache) {
        return this.resource().getPublicExtensions(resourceManager, ctx, flowoverCache);
    }

    public String getFileExtension() {
        return this.parser.getFileExtension();
    }

    public boolean internalRefresh() {
        Resource r = this.parser.parse(this.project, this.getUnderlyingStorage(), this.getFullyQualifiedName());
        if (r == null) {
            return false;
        }
        this.setExtXptResource(r);
        return true;
    }

    public List<Around> getArounds() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }
}

