/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.expr.LocalVarEvalExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvocationOnObjectExpression
extends ExpressionBase {
    private final QualifiedName _functionName;
    private final List<? extends ExpressionBase> _params;
    private final boolean _nullIfFirstParamIsNull;

    public InvocationOnObjectExpression(QualifiedName functionName, List<? extends ExpressionBase> params, boolean nullIfFirstParamIsNull, SourcePos sourcePos) {
        super(sourcePos);
        this._functionName = functionName;
        this._params = params;
        this._nullIfFirstParamIsNull = nullIfFirstParamIsNull;
    }

    public QualifiedName getFunctionName() {
        return this._functionName;
    }

    public List<? extends ExpressionBase> getParams() {
        return this._params;
    }

    public boolean isNullIfFirstParamIsNull() {
        return this._nullIfFirstParamIsNull;
    }

    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        ArrayList<Object> params = new ArrayList<Object>();
        boolean firstParamIsThis = false;
        if (this._params.size() > 0 && this._params.get(0) instanceof LocalVarEvalExpression && ((LocalVarEvalExpression)this._params.get(0)).getLocalVarName().equals("this")) {
            firstParamIsThis = true;
        }
        for (ExpressionBase expressionBase : this._params) {
            params.add(expressionBase.evaluate(ctx));
        }
        if (this._nullIfFirstParamIsNull && params.size() > 0 && params.get(0) == null) {
            ctx.logNullDeRef(this.getPos());
            return null;
        }
        return ctx.getFunctionDefContext().invoke(ctx, this._functionName, params, firstParamIsThis);
    }
}

