/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.notation.providers.internal.copypaste;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.ObjectInfo;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteChildOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.PostPasteChildOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.providers.internal.copypaste.ConnectorViewPasteOperation;
import org.eclipse.gmf.runtime.notation.providers.internal.copypaste.NotationClipboardOperationHelper;

class ConnectorViewPostPasteChildOperation
extends PostPasteChildOperation {
    private boolean pasteSemanticElement;
    private List semanticElementPasteOperations;

    ConnectorViewPostPasteChildOperation(ConnectorViewPasteOperation connectorViewPasteOperation, boolean pasteSemanticElement) {
        super((PasteChildOperation)connectorViewPasteOperation, EMPTY_ARRAY);
        this.pasteSemanticElement = pasteSemanticElement;
    }

    private ConnectorViewPasteOperation getConnectorViewPasteOperation() {
        return (ConnectorViewPasteOperation)this.getPasteChildOperation();
    }

    public void paste() throws Exception {
        EObject pastedElement = this.doPaste();
        if (pastedElement != null) {
            this.setPastedElement(pastedElement);
            this.addPastedElement(pastedElement);
        } else {
            this.addPasteFailuresObject(this.getEObject());
        }
    }

    private EObject doPaste() throws Exception {
        EObject semanticElement;
        View sourceView = this.getConnectorViewPasteOperation().getSourceView();
        View targetView = this.getConnectorViewPasteOperation().getTargetView();
        if (sourceView == null || targetView == null) {
            return null;
        }
        EObject sourceViewContainer = sourceView.eContainer();
        EObject targetViewContainer = targetView.eContainer();
        if (sourceViewContainer == null || targetViewContainer == null) {
            return null;
        }
        if (!sourceViewContainer.equals(targetViewContainer)) {
            Diagram sourceViewDiagram = NotationClipboardOperationHelper.getContainingDiagram((View)sourceViewContainer);
            Diagram targetViewDiagram = NotationClipboardOperationHelper.getContainingDiagram((View)targetViewContainer);
            if (sourceViewDiagram == null || targetViewDiagram == null || !sourceViewDiagram.equals(targetViewDiagram)) {
                return null;
            }
        }
        Edge connectorView = this.getConnectorViewPasteOperation().getConnectorView();
        if (this.pasteSemanticElement && (semanticElement = connectorView.getElement()) != null) {
            String loadedId;
            if (semanticElement.eIsProxy()) {
                semanticElement = ClipboardSupportUtil.resolve((EObject)semanticElement, (Map)this.getParentPasteProcess().getLoadedIDToEObjectMapCopy());
            }
            if ((loadedId = this.getLoadedEObjectID(semanticElement)) != null) {
                this.doPasteSemanticElement();
                String newId = this.getEObjectID(semanticElement);
                if (newId == null) {
                    return null;
                }
            }
        }
        EObject pastedElement = null;
        Diagram pasteTargetDiagram = NotationClipboardOperationHelper.getContainingDiagram((View)sourceViewContainer);
        if (pasteTargetDiagram != null && (pastedElement = ClipboardSupportUtil.appendEObjectAt((EObject)pasteTargetDiagram, (EReference)this.getContainmentFeature(), (EObject)connectorView)) != null) {
            ClipboardSupportUtil.appendEObjectAt((EObject)sourceView, (EReference)NotationPackage.eINSTANCE.getView_SourceEdges(), (EObject)connectorView);
            ClipboardSupportUtil.appendEObjectAt((EObject)targetView, (EReference)NotationPackage.eINSTANCE.getView_TargetEdges(), (EObject)connectorView);
        }
        return pastedElement;
    }

    private void doPasteSemanticElement() throws Exception {
        ArrayList<PasteChildOperation> list = new ArrayList<PasteChildOperation>();
        Iterator it = this.getSemanticElementPasteOperations().iterator();
        while (it.hasNext()) {
            PasteChildOperation operation = (PasteChildOperation)it.next();
            operation.paste();
            PasteChildOperation postPasteOperation = operation.getPostPasteOperation();
            if (postPasteOperation == null) continue;
            list.add(postPasteOperation);
        }
        this.performSemanticElementPostPasteOperations(list);
    }

    private void performSemanticElementPostPasteOperations(List operations) throws Exception {
        if (!operations.isEmpty()) {
            ArrayList<PasteChildOperation> postPasteOperations = new ArrayList<PasteChildOperation>();
            Iterator it = operations.iterator();
            while (it.hasNext()) {
                PasteChildOperation pasteOperation = (PasteChildOperation)it.next();
                pasteOperation.paste();
                PasteChildOperation postPasteOperation = pasteOperation.getPostPasteOperation();
                if (postPasteOperation == null) continue;
                postPasteOperations.add(postPasteOperation);
            }
            this.performSemanticElementPostPasteOperations(postPasteOperations);
        }
    }

    protected List getPostPasteOperations() throws Exception {
        return Collections.EMPTY_LIST;
    }

    private List getSemanticElementPasteOperations() {
        if (this.semanticElementPasteOperations == null) {
            this.semanticElementPasteOperations = new ArrayList();
            EObject semanticPasteTarget = NotationClipboardOperationHelper.getSemanticPasteTarget(this.getConnectorViewPasteOperation().getSourceView());
            if (semanticPasteTarget != null) {
                Iterator alwaysCopyEObjectInfoIt = this.getChildObjectInfo().getCopyAlwaysObjectInfoList().iterator();
                while (alwaysCopyEObjectInfoIt.hasNext()) {
                    ObjectInfo alwaysCopyObjectInfo = (ObjectInfo)alwaysCopyEObjectInfoIt.next();
                    PasteChildOperation pasteOperation = new PasteChildOperation(this.getParentPasteProcess().clone(semanticPasteTarget), alwaysCopyObjectInfo);
                    this.semanticElementPasteOperations.add(pasteOperation);
                }
            }
        }
        return this.semanticElementPasteOperations;
    }
}

