/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

import java.util.Iterator;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.gmf.common.codegen.ImportAssistant;

public class ImportUtil
implements ImportAssistant {
    private final ImportManager myImportManager;
    private final String myPackageName;
    private final String myUnitName;
    private StringBuffer importStringBuffer;
    private int importInsertionPoint;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.common.codegen.ImportUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ImportUtil(String compilationUnitPackage, String compilationUnitName) {
        if (!($assertionsDisabled || compilationUnitName != null && compilationUnitName.trim().length() > 0)) {
            throw new AssertionError();
        }
        this.myImportManager = new ImportManager(compilationUnitPackage);
        this.myImportManager.addMasterImport(compilationUnitPackage == null ? "" : compilationUnitPackage, compilationUnitName);
        this.myPackageName = compilationUnitPackage;
        this.myUnitName = compilationUnitName;
    }

    public void emitPackageStatement(StringBuffer stringBuffer) {
        if (this.myPackageName == null || this.myPackageName.trim().length() == 0) {
            return;
        }
        stringBuffer.append("\npackage ");
        stringBuffer.append(this.myPackageName);
        stringBuffer.append(';');
    }

    public String getCompilationUnitName() {
        return this.myUnitName;
    }

    public void markImportLocation(StringBuffer stringBuffer, GenPackage genPackage) {
        this.markImportLocation(stringBuffer);
        this.myImportManager.addJavaLangImports(genPackage.getJavaLangConflicts());
    }

    public void markImportLocation(StringBuffer stringBuffer) {
        this.importStringBuffer = stringBuffer;
        this.importInsertionPoint = stringBuffer.length();
        this.myImportManager.addCompilationUnitImports(stringBuffer.toString());
    }

    public void emitSortedImports() {
        String NL = System.getProperties().getProperty("line.separator");
        StringBuffer importsBuf = new StringBuffer();
        String previousPackageName = null;
        Iterator iter = this.myImportManager.getImports().iterator();
        while (iter.hasNext()) {
            String importName = (String)iter.next();
            int index = importName.lastIndexOf(".");
            if (index != -1) {
                String packageName = importName.substring(0, index);
                if (previousPackageName != null && !previousPackageName.equals(packageName)) {
                    importsBuf.append(NL);
                }
                previousPackageName = packageName;
            }
            importsBuf.append(String.valueOf(NL) + "import " + importName + ";");
        }
        this.importStringBuffer.insert(this.importInsertionPoint, importsBuf.toString());
    }

    public String getImportedName(String qualifiedName) {
        int index = qualifiedName.indexOf("$");
        this.myImportManager.addImport(index == -1 ? qualifiedName : qualifiedName.substring(0, index));
        return this.myImportManager.getImportedName(qualifiedName);
    }

    public void addImport(String qualifiedName) {
        this.myImportManager.addImport(qualifiedName);
    }

    public void registerInnerClass(String innerClassName) {
        this.myImportManager.addPseudoImport(innerClassName);
    }

    public void addImport(String packageName, String shortName) {
        this.myImportManager.addImport(packageName, shortName);
    }
}

