/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.server.Mapper;
import org.eclipse.emf.cdo.server.ResourceInfo;
import org.eclipse.emf.cdo.server.ResourceManager;
import org.eclipse.emf.cdo.server.impl.ResourceInfoImpl;
import org.eclipse.net4j.spring.impl.ServiceImpl;

public class ResourceManagerImpl
extends ServiceImpl
implements ResourceManager {
    private Map<Integer, ResourceInfo> ridToResourceMap = new HashMap<Integer, ResourceInfo>();
    private Map<String, ResourceInfo> pathToResourceMap = new HashMap<String, ResourceInfo>();

    public void registerResourceInfo(ResourceInfo resourceInfo) {
        if (this.isDebugEnabled()) {
            this.debug("Registering " + resourceInfo);
        }
        this.ridToResourceMap.put(resourceInfo.getRID(), resourceInfo);
        this.pathToResourceMap.put(resourceInfo.getPath(), resourceInfo);
    }

    public ResourceInfo registerResourceInfo(String resourcePath, int rid, long nextOIDFragment) {
        ResourceInfoImpl resourceInfo = new ResourceInfoImpl(resourcePath, rid, nextOIDFragment);
        this.registerResourceInfo(resourceInfo);
        return resourceInfo;
    }

    public ResourceInfo getResourceInfo(String path, Mapper mapper) {
        ResourceInfo resourceInfo = this.pathToResourceMap.get(path);
        if (resourceInfo == null) {
            resourceInfo = mapper.selectResourceInfo(path);
            if (resourceInfo == null) {
                return null;
            }
            this.registerResourceInfo(resourceInfo);
        }
        return resourceInfo;
    }

    public ResourceInfo getResourceInfo(int rid, Mapper mapper) {
        ResourceInfo resourceInfo = this.ridToResourceMap.get(new Integer(rid));
        if (resourceInfo == null) {
            resourceInfo = mapper.selectResourceInfo(rid);
            if (resourceInfo == null) {
                return null;
            }
            this.registerResourceInfo(resourceInfo);
        }
        return resourceInfo;
    }

    protected void deactivate() throws Exception {
        this.pathToResourceMap = null;
        this.ridToResourceMap = null;
        super.deactivate();
    }
}

