/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clustering;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mergeSuggestion.MergeSuggestion;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroupDetectionResult;
import org.eclipse.emf.henshin.variability.mergein.clustering.CloneGroupCopier;
import org.eclipse.emf.henshin.variability.mergein.clustering.CloneHierarchy;
import org.eclipse.emf.henshin.variability.mergein.clustering.DefaultAgglomerativeRuleClusterer;
import org.eclipse.emf.henshin.variability.mergein.clustering.HierarchicalMergeSuggestionBuilder;
import org.eclipse.emf.henshin.variability.mergein.clustering.MergeClusterer;
import org.eclipse.emf.henshin.variability.mergein.clustering.SubCloneRelation;

public abstract class GreedySubCloneClusterer
extends MergeClusterer {
    private static final double WEIGHT_CARDINALITY = 0.0;
    private static final double WEIGHT_CLONE_SIZE = 1.0;
    private double clusteringThreshold;
    private boolean includeRhs;

    protected GreedySubCloneClusterer(CloneGroupDetectionResult cloneGroupDetectionResult) {
        super(cloneGroupDetectionResult);
    }

    public GreedySubCloneClusterer() {
    }

    public GreedySubCloneClusterer(CloneGroupDetectionResult cloneGroupDetectionResult, double clusteringThreshold, boolean includeRhs) {
        super(cloneGroupDetectionResult);
        this.includeRhs = includeRhs;
        this.clusteringThreshold = clusteringThreshold;
    }

    @Override
    public MergeSuggestion createMergeSuggestion() {
        List<CloneGroup> cloneGroups = this.cloneGroupDetectionResult.getCloneGroups();
        List<List<Rule>> clusters = new DefaultAgglomerativeRuleClusterer().clusterRules(cloneGroups, this.clusteringThreshold, this.includeRhs);
        CloneHierarchy cloneHierarchy = new CloneHierarchy();
        for (List<Rule> cluster : clusters) {
            List<CloneGroup> restrictedCloneGroups = this.getRestrictedCopy(cloneGroups, cluster);
            this.removeEmptyCloneGroups(restrictedCloneGroups);
            while (!restrictedCloneGroups.isEmpty()) {
                CloneGroup topCloneGroup = this.getTopCloneGroup(restrictedCloneGroups);
                restrictedCloneGroups.remove(topCloneGroup);
                HashSet<Rule> considered = new HashSet<Rule>();
                if (!topCloneGroup.getRules().isEmpty()) {
                    cloneHierarchy.addBasisCloneGroup(topCloneGroup);
                    considered.addAll(topCloneGroup.getRules());
                    this.addSubClones(restrictedCloneGroups, cloneHierarchy, topCloneGroup);
                    restrictedCloneGroups.removeAll(cloneHierarchy.getTransitiveSubClones(topCloneGroup));
                    for (CloneGroup cg : cloneHierarchy.getTransitiveSubClones(topCloneGroup)) {
                        considered.addAll(cg.getRules());
                    }
                }
                for (CloneGroup minorCloneGroup : restrictedCloneGroups) {
                    minorCloneGroup.removeRules(considered);
                }
                this.removeEmptyCloneGroups(restrictedCloneGroups);
            }
        }
        MergeSuggestion result = new HierarchicalMergeSuggestionBuilder().createFromCloneHierarchy(cloneHierarchy);
        return result;
    }

    private void addSubClones(List<CloneGroup> cloneGroups, CloneHierarchy cloneHierarchy, CloneGroup topCloneGroup) {
        HashSet<CloneGroup> subClones = new HashSet<CloneGroup>();
        for (CloneGroup cg : cloneGroups) {
            if (!this.isSubCloneCandidate(topCloneGroup, cg) || !SubCloneRelation.isSubClone(topCloneGroup, cg)) continue;
            subClones.add(cg);
        }
        for (CloneGroup cg : subClones) {
            cloneHierarchy.addChild(topCloneGroup, cg);
        }
    }

    private List<CloneGroup> getRestrictedCopy(List<CloneGroup> cloneGroups, List<Rule> rules) {
        ArrayList<CloneGroup> result = new ArrayList<CloneGroup>();
        for (CloneGroup cg : cloneGroups) {
            if (!this.concernsAtLeastTwoRules(cg, rules)) continue;
            result.add(CloneGroupCopier.createRestrictedCopy(cg, rules));
        }
        return result;
    }

    private boolean concernsAtLeastTwoRules(CloneGroup cg, List<Rule> rules) {
        int count = 0;
        for (Rule rule : cg.getRules()) {
            if (rules.contains(rule)) {
                ++count;
            }
            if (count != 2) continue;
            return true;
        }
        return false;
    }

    abstract boolean isSubCloneCandidate(CloneGroup var1, CloneGroup var2);

    private void removeEmptyCloneGroups(List<CloneGroup> cloneGroups) {
        HashSet<CloneGroup> cgs = new HashSet<CloneGroup>(cloneGroups);
        for (CloneGroup cg : cgs) {
            if (cg.getRules().size() >= 2) continue;
            cloneGroups.remove(cg);
        }
    }

    protected CloneGroup getTopCloneGroup(List<CloneGroup> cloneGroups) {
        CloneGroup result = cloneGroups.get(0);
        double topScore = -1.0;
        for (CloneGroup cg : cloneGroups) {
            double cgScore = this.calculateScore(cg);
            if (!(cgScore > topScore)) continue;
            result = cg;
            topScore = cgScore;
        }
        return result;
    }

    private double calculateScore(CloneGroup cg) {
        return 0.0 * (double)cg.getRules().size() + 1.0 * (double)cg.getSize();
    }
}

