/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.debug;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.debug.DebugValueEObject;
import org.eclipse.emf.henshin.interpreter.debug.DebugValueObject;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugElement;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugValue;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;

public class HenshinDebugVariable
extends HenshinDebugElement
implements IVariable {
    private String name;
    private HenshinDebugValue value;
    private Variable variable;
    private final boolean isConstraintType;
    private final boolean isConstraint;

    public HenshinDebugVariable(IDebugTarget target, String name, String value, Variable variable) {
        this(target, name, value, variable.typeConstraint.type.getName());
        this.variable = variable;
    }

    public HenshinDebugVariable(IDebugTarget target, String name, String value, String declaredType) {
        this(target, name, new DebugValueObject(target, null, declaredType, value, -1));
    }

    public HenshinDebugVariable(IDebugTarget target, String name, HenshinDebugValue value) {
        super(target);
        this.name = name;
        this.value = value;
        this.isConstraintType = "Constraint Type".equals(name);
        this.isConstraint = "Constraint".equals(name);
    }

    public boolean isConstraint() {
        return this.isConstraint;
    }

    public boolean isConstraintType() {
        return this.isConstraintType;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setValue(String expression) throws DebugException {
        this.value = new DebugValueEObject(this.getDebugTarget(), null, expression, (EObject)this.value, -1);
    }

    public void setValue(IValue value) throws DebugException {
        this.setValue(value.getValueString());
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return ((Object)((Object)this.value)).toString();
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HenshinDebugVariable other = (HenshinDebugVariable)((Object)obj);
        return this.name.equals(other.name) && this.value.equals((Object)other.value);
    }
}

