/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.matcher;

import aima.core.logic.propositional.parsing.ast.Sentence;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.InconsistentRuleException;
import org.eclipse.emf.henshin.variability.matcher.FeatureExpression;
import org.eclipse.emf.henshin.variability.matcher.RulePreparator;
import org.eclipse.emf.henshin.variability.matcher.VariabilityAwareMatch;
import org.eclipse.emf.henshin.variability.util.RuleUtil;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityFactory;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityGraphElement;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityNode;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityRule;

public class VariabilityAwareEngine {
    protected Rule rule;
    protected EGraph graph;
    protected EngineImpl engine;
    protected Map<String, Sentence> expressions;
    protected RuleInfo ruleInfo;
    protected RulePreparator rulePreparator;
    protected int THRESHOLD_MAXIMUM_BASE_MATCHES = 10;
    private static Map<Rule, RuleInfo> ruleInfoRegistry = new HashMap<Rule, RuleInfo>();

    public VariabilityAwareEngine(Rule rule, EGraph graph) throws InconsistentRuleException {
        this.fixInconsistencies(rule);
        if (!RuleUtil.checkRule(rule)) {
            throw new InconsistentRuleException();
        }
        this.rule = rule;
        this.graph = graph;
        this.engine = new EngineImpl(new String[0]);
        this.rulePreparator = new RulePreparator(rule);
        if (!ruleInfoRegistry.containsKey(rule)) {
            ruleInfoRegistry.put(rule, new RuleInfo(rule));
        }
        this.ruleInfo = ruleInfoRegistry.get(rule);
        this.populateExpressionMap();
    }

    private void fixInconsistencies(Rule rule) {
        for (Mapping mapping : rule.getMappings()) {
            VariabilityNode origin = VariabilityFactory.createVariabilityNode(mapping.getOrigin());
            VariabilityNode image = VariabilityFactory.createVariabilityNode(mapping.getImage());
            if (origin.getPresenceCondition() == image.getPresenceCondition()) continue;
            image.setPresenceCondition(origin.getPresenceCondition());
        }
    }

    private void populateExpressionMap() {
        if (ruleInfoRegistry.containsKey(this.rule)) {
            this.expressions = this.ruleInfo.getExpressions();
        }
    }

    public Set<VariabilityAwareMatch> findMatches() {
        BitSet bs = this.rulePreparator.prepare(this.ruleInfo, this.ruleInfo.getPc2Elem().keySet(), this.rule.isInjectiveMatching(), true);
        HashSet<Match> baseMatches = new HashSet<Match>();
        Iterator it = this.engine.findMatches(this.rule, this.graph, null).iterator();
        while (it.hasNext()) {
            if (baseMatches.size() < this.THRESHOLD_MAXIMUM_BASE_MATCHES) {
                baseMatches.add((Match)it.next());
                continue;
            }
            baseMatches.clear();
            baseMatches.add(null);
            System.out.println("Too many base matches:" + this.rule);
            break;
        }
        this.rulePreparator.undo();
        HashSet<VariabilityAwareMatch> matches = new HashSet<VariabilityAwareMatch>();
        if (!baseMatches.isEmpty()) {
            LinkedList<Sentence> conditions = new LinkedList<Sentence>();
            conditions.addAll(this.expressions.values());
            MatchingInfo mo = new MatchingInfo(conditions, this.ruleInfo);
            mo.getMatchedSubrules().add(bs);
            mo.set(this.ruleInfo.getFeatureModel(), null, true);
            this.findMatches(this.rule, mo, baseMatches, matches);
            mo.set(this.ruleInfo.getFeatureModel(), true, null);
        }
        return matches;
    }

    private Set<VariabilityAwareMatch> findMatches(Rule rule, MatchingInfo matchingInfo, Set<Match> baseMatches, Set<VariabilityAwareMatch> matches) {
        Sentence current = this.getFirstNeutral(matchingInfo);
        if (current == null) {
            this.findMatchInner(rule, matchingInfo, baseMatches, matches);
        } else {
            matchingInfo.set(current, null, true);
            this.findMatchInner(rule, matchingInfo, baseMatches, matches);
            matchingInfo.set(current, true, false);
            this.findMatchInner(rule, matchingInfo, baseMatches, matches);
            matchingInfo.set(current, false, null);
        }
        return matches;
    }

    private Sentence getFirstNeutral(MatchingInfo matchingInfo) {
        for (Sentence e : matchingInfo.getInfo().keySet()) {
            if (matchingInfo.getInfo().get(e) != null) continue;
            return e;
        }
        return null;
    }

    private Set<VariabilityAwareMatch> findMatchInner(Rule rule, MatchingInfo matchingInfo, Set<Match> baseMatches, Set<VariabilityAwareMatch> matches) {
        Set<Sentence> newContradictory = this.getNewContradictory(matchingInfo);
        matchingInfo.setAll(newContradictory, null, false);
        Set<Sentence> newImplicated = this.getNewImplicated(matchingInfo);
        matchingInfo.setAll(newImplicated, null, true);
        if (matchingInfo.getNeutrals().isEmpty()) {
            BitSet reducedRule = this.rulePreparator.prepare(this.ruleInfo, matchingInfo.getAssumedFalse(), this.determineInjectiveMatching(matchingInfo), false);
            if (!matchingInfo.getMatchedSubrules().contains(reducedRule)) {
                for (Match bm : baseMatches) {
                    Iterator classicMatches = this.engine.findMatches(rule, this.graph, bm).iterator();
                    RulePreparator prep = this.rulePreparator.getSnapShot();
                    while (classicMatches.hasNext()) {
                        Match next = (Match)classicMatches.next();
                        matches.add(new VariabilityAwareMatch(next, matchingInfo.getAssumedTrue(), rule, prep));
                    }
                }
                matchingInfo.getMatchedSubrules().add(reducedRule);
            }
            this.rulePreparator.undo();
        } else {
            this.findMatches(rule, matchingInfo, baseMatches, matches);
        }
        matchingInfo.setAll(newImplicated, true, null);
        matchingInfo.setAll(newContradictory, false, null);
        return matches;
    }

    private boolean determineInjectiveMatching(MatchingInfo matchingInfo) {
        return FeatureExpression.contradicts(this.ruleInfo.getInjectiveMatching(), this.getKnowledgeBase(matchingInfo));
    }

    private Set<Sentence> getNewContradictory(MatchingInfo mo) {
        HashSet<Sentence> result = new HashSet<Sentence>();
        Sentence knowledge = this.getKnowledgeBase(mo);
        for (Sentence e : mo.getNeutrals()) {
            if (!FeatureExpression.contradicts(knowledge, e)) continue;
            result.add(e);
        }
        return result;
    }

    private Set<Sentence> getNewImplicated(MatchingInfo mo) {
        HashSet<Sentence> result = new HashSet<Sentence>();
        Sentence knowledge = this.getKnowledgeBase(mo);
        for (Sentence e : mo.getNeutrals()) {
            if (!FeatureExpression.implies(knowledge, e)) continue;
            result.add(e);
        }
        return result;
    }

    private Sentence getKnowledgeBase(MatchingInfo mo) {
        Sentence fe = FeatureExpression.TRUE;
        for (Sentence t : mo.getAssumedTrue()) {
            fe = FeatureExpression.and(fe, t);
        }
        for (Sentence f : mo.getAssumedFalse()) {
            fe = FeatureExpression.andNot(fe, f);
        }
        return fe;
    }

    private static boolean presenceConditionEmpty(GraphElement elem) {
        String presenceCondition = VariabilityFactory.createVariabilityGraphElement(elem).getPresenceCondition();
        return presenceCondition == null || presenceCondition.isEmpty();
    }

    public static class MatchingInfo {
        private Map<Sentence, Boolean> info = new LinkedHashMap<Sentence, Boolean>();
        private Set<Sentence> assumedTrue = new HashSet<Sentence>();
        private Set<Sentence> assumedFalse = new HashSet<Sentence>();
        private Set<Sentence> neutrals = new HashSet<Sentence>();
        private Set<BitSet> matchedSubRules = new HashSet<BitSet>();

        public MatchingInfo(List<Sentence> conditions, RuleInfo ruleInfo) {
            for (Sentence expr : conditions) {
                this.info.put(expr, null);
            }
            this.assumedTrue.add(ruleInfo.getFeatureModel());
            this.neutrals.addAll(conditions);
        }

        public Set<BitSet> getMatchedSubrules() {
            return this.matchedSubRules;
        }

        public void setAll(Collection<Sentence> exprs, Boolean old, Boolean new_) {
            for (Sentence expr : exprs) {
                this.set(expr, old, new_);
            }
        }

        public void set(Sentence expr, Boolean old, Boolean new_) {
            if (old == null) {
                this.neutrals.remove(expr);
            } else if (old.booleanValue()) {
                this.assumedTrue.remove(expr);
            } else {
                this.assumedFalse.remove(expr);
            }
            if (new_ == null) {
                this.neutrals.add(expr);
            } else if (new_.booleanValue()) {
                this.assumedTrue.add(expr);
            } else {
                this.assumedFalse.add(expr);
            }
            this.info.put(expr, new_);
        }

        public Set<Sentence> getAssumedTrue() {
            return this.assumedTrue;
        }

        public Set<Sentence> getAssumedFalse() {
            return this.assumedFalse;
        }

        public Map<Sentence, Boolean> getInfo() {
            return this.info;
        }

        public Set<Sentence> getNeutrals() {
            return this.neutrals;
        }
    }

    public static class RuleInfo {
        VariabilityRule rule;
        Map<String, Sentence> usedExpressions;
        Map<Sentence, Set<GraphElement>> pc2elem;
        Map<Node, Set<Mapping>> node2Mapping;
        Sentence featureModel;
        Sentence injectiveMatching;

        public RuleInfo(Rule rule) {
            this.rule = VariabilityFactory.createVariabilityRule(rule);
            this.featureModel = FeatureExpression.getExpr(this.rule.getFeatureModel());
            String injective = this.rule.getInjectiveMatchingPresenceCondition();
            if (injective == null) {
                injective = String.valueOf(rule.isInjectiveMatching());
            }
            this.injectiveMatching = FeatureExpression.getExpr(injective);
            this.populateMaps();
        }

        public Map<Sentence, Set<GraphElement>> getPc2Elem() {
            return this.pc2elem;
        }

        public Map<String, Sentence> getExpressions() {
            return this.usedExpressions;
        }

        public Sentence getFeatureModel() {
            return this.featureModel;
        }

        public void populateMaps() {
            this.usedExpressions = new HashMap<String, Sentence>();
            this.node2Mapping = new HashMap<Node, Set<Mapping>>();
            this.pc2elem = new HashMap<Sentence, Set<GraphElement>>();
            TreeIterator<EObject> it = this.rule.eAllContents();
            while (it.hasNext()) {
                VariabilityGraphElement g;
                EObject o = (EObject)it.next();
                if ((o instanceof Node || o instanceof Edge || o instanceof Attribute) && !VariabilityAwareEngine.presenceConditionEmpty(g = VariabilityFactory.createVariabilityGraphElement((GraphElement)o))) {
                    String pc = g.getPresenceCondition();
                    Sentence expr = FeatureExpression.getExpr(pc);
                    this.usedExpressions.put(pc, expr);
                    if (!this.pc2elem.containsKey(expr)) {
                        this.pc2elem.put(expr, new HashSet());
                    }
                    this.pc2elem.get(expr).add((GraphElement)o);
                }
                if (!(o instanceof Mapping)) continue;
                Mapping m = (Mapping)o;
                Node image = m.getImage();
                Set<Mapping> set = this.node2Mapping.get(image);
                if (set == null) {
                    set = new HashSet<Mapping>();
                    this.node2Mapping.put(image, set);
                }
                set.add(m);
                Node origin = m.getOrigin();
                set = this.node2Mapping.get(origin);
                if (set == null) {
                    set = new HashSet<Mapping>();
                    this.node2Mapping.put(origin, set);
                }
                set.add(m);
            }
            if (this.featureModel != null && !this.featureModel.equals("") && !this.pc2elem.containsKey(this.featureModel)) {
                this.pc2elem.put(this.featureModel, new HashSet());
            }
        }

        public Map<Node, Set<Mapping>> getNode2Mapping() {
            return this.node2Mapping;
        }

        public Sentence getInjectiveMatching() {
            return this.injectiveMatching;
        }
    }
}

