/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.equality;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceNavigator {
    private final boolean withNonContainment;
    private final boolean withDerived;
    Link last;
    boolean start;
    boolean end;
    private final Map<EClass, List<EReference>> referenceCache;

    public ResourceNavigator(Resource resource, boolean withNonContainment, boolean withDerived) {
        this.withNonContainment = withNonContainment;
        this.withDerived = withDerived;
        this.referenceCache = new HashMap<EClass, List<EReference>>();
        if (resource.getContents().isEmpty()) {
            this.start = true;
            this.end = true;
        } else {
            this.start = false;
            this.end = false;
            this.last = new Link();
            this.last.targets = resource.getContents();
            this.last.index = 0;
        }
    }

    public EObject getSource() {
        if (this.start || this.end) {
            return null;
        }
        return this.last.source;
    }

    public EObject getTarget() {
        if (this.start || this.end) {
            return null;
        }
        return this.last.targets.get(this.last.index);
    }

    public EReference getReference() {
        if (this.start || this.end) {
            return null;
        }
        return this.last.reference;
    }

    public int getIndex() {
        if (this.start || this.end) {
            return -1;
        }
        return this.last.index;
    }

    public boolean isStart() {
        return this.start;
    }

    public boolean isEnd() {
        return this.end;
    }

    public EObject forward() {
        if (this.end) {
            return null;
        }
        if (this.start) {
            this.start = false;
            return this.getTarget();
        }
        EObject target = this.getTarget();
        for (EReference reference : this.getReferences(target)) {
            Link link = this.createLink(target, reference, 0);
            if (link == null) continue;
            link.previous = this.last;
            this.last = link;
            return this.getTarget();
        }
        return this.skip();
    }

    public EObject skip() {
        if (this.end) {
            return null;
        }
        if (this.start) {
            this.start = false;
            return this.getTarget();
        }
        Link link = this.last;
        Link next = null;
        while (link != null) {
            if (!link.visited && (next = this.nextLink(link)) != null) break;
            link = link.previous;
        }
        if (next != null) {
            link.visited = true;
            next.previous = this.last;
            this.last = next;
            return this.getTarget();
        }
        this.end = true;
        return null;
    }

    public EObject backward() {
        if (this.start) {
            return null;
        }
        if (this.end) {
            this.end = false;
            return this.getTarget();
        }
        if (this.last.previous != null) {
            Link link = this.last.previous;
            while (link != null) {
                if (link.source == this.last.source) {
                    link.visited = false;
                    break;
                }
                link = link.previous;
            }
            this.last = this.last.previous;
            return this.getTarget();
        }
        this.start = true;
        return null;
    }

    private List<EReference> getReferences(EObject object) {
        List<EReference> references = this.referenceCache.get(object.eClass());
        if (references == null) {
            references = new ArrayList<EReference>();
            for (EReference ref : object.eClass().getEAllReferences()) {
                if (!this.withNonContainment && !ref.isContainment() || !this.withDerived && ref.isDerived()) continue;
                references.add(ref);
            }
            this.referenceCache.put(object.eClass(), references);
        }
        return references;
    }

    private Link nextLink(Link link) {
        if (link.index < link.targets.size() - 1) {
            Link next = new Link();
            next.reference = link.reference;
            next.index = link.index + 1;
            next.source = link.source;
            next.targets = link.targets;
            return next;
        }
        if (link.reference != null) {
            List<EReference> refs = this.getReferences(link.source);
            int i = refs.indexOf(link.reference) + 1;
            while (i < refs.size()) {
                Link next = this.createLink(link.source, refs.get(i), 0);
                if (next != null) {
                    return next;
                }
                ++i;
            }
        }
        return null;
    }

    private Link createLink(EObject source, EReference reference, int index) {
        Link link = null;
        if (reference.isMany()) {
            List values = (List)source.eGet((EStructuralFeature)reference);
            if (index < values.size()) {
                link = new Link();
                link.reference = reference;
                link.index = index;
                link.source = source;
                link.targets = values;
            }
        } else {
            EObject value = (EObject)source.eGet((EStructuralFeature)reference);
            if (value != null && index == 0) {
                link = new Link();
                link.reference = reference;
                link.index = index;
                link.source = source;
                link.targets = Collections.singletonList(value);
            }
        }
        return link;
    }

    static class Link {
        EObject source;
        EReference reference;
        List<EObject> targets;
        int index;
        boolean visited;
        Link previous;

        Link() {
        }
    }
}

