/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainChange;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;

public class ReferenceConstraint
implements BinaryConstraint {
    final Variable targetVariable;
    final EReference reference;
    final Object index;
    final boolean isConstantIndex;

    public ReferenceConstraint(Variable target, EReference reference, Object index, boolean isConstantIndex) {
        this.targetVariable = target;
        this.reference = reference;
        this.index = index;
        this.isConstantIndex = isConstantIndex;
    }

    public ReferenceConstraint(Variable target, EReference reference) {
        this(target, reference, null, true);
    }

    @Override
    public boolean check(DomainSlot source, DomainSlot target) {
        List<EObject> targetObjects;
        if (!source.locked) {
            return false;
        }
        if (this.reference.isMany()) {
            targetObjects = (List<EObject>)source.value.eGet((EStructuralFeature)this.reference);
            if (targetObjects.isEmpty()) {
                return false;
            }
        } else {
            EObject obj = (EObject)source.value.eGet((EStructuralFeature)this.reference);
            if (obj == null) {
                return false;
            }
            targetObjects = Collections.singletonList(obj);
        }
        Integer calculatedIndex = null;
        if (this.isConstantIndex) {
            calculatedIndex = this.index != null ? Integer.valueOf(((Number)this.index).intValue()) : null;
        } else {
            String parameterName = (String)this.index;
            if (source.conditionHandler.isSet(parameterName)) {
                calculatedIndex = ((Number)source.conditionHandler.getParameter(parameterName)).intValue();
            }
        }
        if (calculatedIndex != null && calculatedIndex < 0) {
            calculatedIndex = targetObjects.size() + calculatedIndex;
        }
        if (target.locked) {
            if (!this.isConstantIndex && !source.conditionHandler.isSet((String)this.index)) {
                calculatedIndex = targetObjects.indexOf(target.value);
                if (target.conditionHandler.setParameter((String)this.index, calculatedIndex)) {
                    target.initializedParameters.add((String)this.index);
                    return true;
                }
                target.conditionHandler.unsetParameter((String)this.index);
                return false;
            }
            return calculatedIndex != null ? targetObjects.indexOf(target.value) == calculatedIndex.intValue() : targetObjects.contains(target.value);
        }
        DomainChange change = new DomainChange(target, target.temporaryDomain);
        source.remoteChangeMap.put(this, change);
        target.temporaryDomain = calculatedIndex != null ? (calculatedIndex >= 0 && calculatedIndex < targetObjects.size() ? Collections.singletonList(targetObjects.get(calculatedIndex)) : Collections.emptyList()) : new ArrayList<EObject>(targetObjects);
        if (change.originalValues != null) {
            target.temporaryDomain.retainAll(change.originalValues);
        }
        return !target.temporaryDomain.isEmpty();
    }
}

