/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.actions.EdgeActionHelper;
import org.eclipse.emf.henshin.model.actions.NodeActionHelper;
import org.eclipse.emf.henshin.model.impl.GraphImpl;
import org.eclipse.emf.henshin.model.impl.MappingContainmentListImpl;
import org.eclipse.emf.henshin.model.impl.MappingListImpl;
import org.eclipse.emf.henshin.model.impl.NodeImpl;
import org.eclipse.emf.henshin.model.impl.UnitImpl;

public class RuleImpl
extends UnitImpl
implements Rule {
    protected Graph lhs;
    protected Graph rhs;
    protected EList<AttributeCondition> attributeConditions;
    protected EList<Mapping> mappings;
    protected static final boolean CHECK_DANGLING_EDEFAULT = true;
    protected boolean checkDangling = true;
    protected static final boolean INJECTIVE_MATCHING_EDEFAULT = true;
    protected boolean injectiveMatching = true;
    protected EList<Rule> multiRules;
    protected EList<Mapping> multiMappings;

    @Override
    protected EClass eStaticClass() {
        return HenshinPackage.Literals.RULE;
    }

    @Override
    public Graph getLhs() {
        if (this.lhs == null) {
            GraphImpl theLhs = new GraphImpl();
            theLhs.setName("Lhs");
            this.setLhs(theLhs);
        }
        return this.lhs;
    }

    public NotificationChain basicSetLhs(Graph newLhs, NotificationChain msgs) {
        Graph oldLhs = this.lhs;
        this.lhs = newLhs;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldLhs, (Object)newLhs);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLhs(Graph newLhs) {
        if (newLhs != this.lhs) {
            NotificationChain msgs = null;
            if (this.lhs != null) {
                msgs = ((InternalEObject)this.lhs).eInverseRemove((InternalEObject)this, -6, null, msgs);
            }
            if (newLhs != null) {
                msgs = ((InternalEObject)newLhs).eInverseAdd((InternalEObject)this, -6, null, msgs);
            }
            if ((msgs = this.basicSetLhs(newLhs, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newLhs, (Object)newLhs));
        }
    }

    @Override
    public Graph getRhs() {
        if (this.rhs == null) {
            GraphImpl theRhs = new GraphImpl();
            theRhs.setName("Rhs");
            this.setRhs(theRhs);
        }
        return this.rhs;
    }

    public NotificationChain basicSetRhs(Graph newRhs, NotificationChain msgs) {
        Graph oldRhs = this.rhs;
        this.rhs = newRhs;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldRhs, (Object)newRhs);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setRhs(Graph newRhs) {
        if (newRhs != this.rhs) {
            NotificationChain msgs = null;
            if (this.rhs != null) {
                msgs = ((InternalEObject)this.rhs).eInverseRemove((InternalEObject)this, -7, null, msgs);
            }
            if (newRhs != null) {
                msgs = ((InternalEObject)newRhs).eInverseAdd((InternalEObject)this, -7, null, msgs);
            }
            if ((msgs = this.basicSetRhs(newRhs, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newRhs, (Object)newRhs));
        }
    }

    @Override
    public EList<AttributeCondition> getAttributeConditions() {
        if (this.attributeConditions == null) {
            this.attributeConditions = new EObjectContainmentWithInverseEList(AttributeCondition.class, (InternalEObject)this, 7, 2);
        }
        return this.attributeConditions;
    }

    @Override
    public MappingList getMappings() {
        if (this.mappings == null) {
            this.mappings = new MappingContainmentListImpl((InternalEObject)this, 8);
        }
        return (MappingList)this.mappings;
    }

    @Override
    public Rule getKernelRule() {
        EObject container = this.eContainer();
        if (container instanceof Rule) {
            return (Rule)container;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Rule getRootRule() {
        kernel = this.getKernelRule();
        if (kernel != null) ** GOTO lbl5
        return this;
lbl-1000:
        // 1 sources

        {
            kernel = kernel.getKernelRule();
lbl5:
            // 2 sources

            ** while (kernel.getKernelRule() != null)
        }
lbl6:
        // 1 sources

        return kernel;
    }

    @Override
    public Rule getMultiRule(String name) {
        name = name == null ? "" : name.trim();
        for (Rule multiRule : this.getMultiRules()) {
            String n = multiRule.getName();
            String string = n = n == null ? "" : n.trim();
            if (!name.equals(n)) continue;
            return multiRule;
        }
        return null;
    }

    @Override
    public EList<Rule> getMultiRulePath(Rule multiRule) {
        Vector<Rule> path = new Vector<Rule>();
        while (multiRule != null && multiRule != this) {
            path.add(0, multiRule);
            multiRule = multiRule.getKernelRule();
        }
        if (multiRule != this) {
            path.clear();
        }
        return ECollections.unmodifiableEList((EList)new BasicEList(path));
    }

    @Override
    public EList<Rule> getAllMultiRules() {
        BasicEList allMultiRules = new BasicEList();
        allMultiRules.addAll(this.getMultiRules());
        for (Rule multiRule : this.getMultiRules()) {
            allMultiRules.addAll(multiRule.getAllMultiRules());
        }
        return ECollections.unmodifiableEList((EList)allMultiRules);
    }

    @Override
    public MappingList getAllMappings() {
        MappingListImpl mappings = new MappingListImpl();
        TreeIterator it = this.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof Mapping)) continue;
            mappings.add((Mapping)obj);
        }
        return mappings;
    }

    @Override
    public EList<Node> getActionNodes(Action action) {
        List<Node> result = NodeActionHelper.INSTANCE.getActionElements(this, action);
        return ECollections.unmodifiableEList((EList)new BasicEList(result));
    }

    @Override
    public EList<Edge> getActionEdges(Action action) {
        List<Edge> result = EdgeActionHelper.INSTANCE.getActionElements(this, action);
        return ECollections.unmodifiableEList((EList)new BasicEList(result));
    }

    @Override
    public EList<Node> getParameterNodes() {
        BasicEList nodes = new BasicEList();
        for (Parameter param : this.getParameters()) {
            Node node = this.findNodeByName(param.getName());
            if (node == null) continue;
            nodes.add((Object)node);
        }
        return nodes;
    }

    private static Node findNodeByName(String name, Graph graph) {
        for (Node node : graph.getNodes()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    private Node findNodeByName(String name) {
        Node node = RuleImpl.findNodeByName(name, this.getLhs());
        if (node == null) {
            node = RuleImpl.findNodeByName(name, this.getRhs());
        }
        return node;
    }

    @Override
    public boolean isMultiRule() {
        return this.getKernelRule() != null;
    }

    @Override
    public Node createNode(EClass type) {
        NodeImpl lhsNode = new NodeImpl();
        NodeImpl rhsNode = new NodeImpl();
        lhsNode.setType(type);
        rhsNode.setType(type);
        this.getLhs().getNodes().add((Object)lhsNode);
        this.getRhs().getNodes().add((Object)rhsNode);
        this.getMappings().add(lhsNode, rhsNode);
        return lhsNode.getActionNode();
    }

    private void getNodeMappings(Set<Node> nodes, Set<Mapping> mappings, boolean transitive) {
        boolean changed;
        do {
            changed = false;
            Iterator<Mapping> iterator = this.getAllMappings().iterator();
            block1: while (iterator.hasNext()) {
                Mapping m = (Mapping)iterator.next();
                if (mappings.contains(m)) continue;
                for (Node n : nodes) {
                    if (m.getOrigin() != n && m.getImage() != n) continue;
                    mappings.add(m);
                    changed = true;
                    continue block1;
                }
            }
            if (!changed || !transitive) continue;
            for (Mapping m : mappings) {
                if (m.getOrigin() != null) {
                    nodes.add(m.getOrigin());
                }
                if (m.getImage() == null) continue;
                nodes.add(m.getImage());
            }
        } while (changed);
    }

    @Override
    public boolean removeNode(Node node, boolean removeMapped) {
        if (this.getRootRule() != this) {
            return this.getRootRule().removeNode(node, removeMapped);
        }
        HashSet<Mapping> mappings = new HashSet<Mapping>();
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.add(node);
        this.getNodeMappings(nodes, mappings, removeMapped);
        for (Mapping m : mappings) {
            m.setOrigin(null);
            m.setImage(null);
            EcoreUtil.remove((EObject)m);
        }
        for (Node n : nodes) {
            n.getGraph().removeNode(n);
        }
        return true;
    }

    @Override
    public Edge createEdge(Node source, Node target, EReference type) {
        Graph sourceGraph;
        if (this.getRootRule() != this) {
            return this.getRootRule().createEdge(source, target, type);
        }
        if (!this.canCreateEdge(source, target, type)) {
            return null;
        }
        List<Node> sourceAndTarget = this.getSourceAndTargetForEdgeCreation(source, target, false);
        Edge edge = (source = sourceAndTarget.get(0)).getOutgoing(type, target = sourceAndTarget.get(1));
        if (edge == null) {
            edge = HenshinFactory.eINSTANCE.createEdge(source, target, type);
        }
        if ((sourceGraph = source.getGraph()) != null && sourceGraph.isLhs() && sourceGraph == target.getGraph() && sourceGraph.getRule() != null) {
            Edge edge2;
            source = sourceGraph.getRule().getMappings().getImage(source, sourceGraph.getRule().getRhs());
            target = sourceGraph.getRule().getMappings().getImage(target, sourceGraph.getRule().getRhs());
            if (source != null && target != null && (edge2 = source.getOutgoing(type, target)) == null) {
                edge2 = HenshinFactory.eINSTANCE.createEdge(source, target, type);
            }
        }
        return edge;
    }

    @Override
    public boolean canCreateEdge(Node source, Node target, EReference type) {
        if (this.getRootRule() != this) {
            return this.getRootRule().canCreateEdge(source, target, type);
        }
        EClass targetType = target.getType();
        EClass sourceType = source.getType();
        if (source == null || target == null || sourceType == null || targetType == null || type == null) {
            return false;
        }
        if (!sourceType.getEAllReferences().contains((Object)type)) {
            return false;
        }
        if (!type.getEReferenceType().isSuperTypeOf(targetType) && !targetType.isSuperTypeOf(type.getEReferenceType()) && type.getEReferenceType() != EcorePackage.eINSTANCE.getEObject()) {
            return false;
        }
        List<Node> sourceAndTarget = this.getSourceAndTargetForEdgeCreation(source, target, false);
        if (sourceAndTarget == null || sourceAndTarget.size() != 2) {
            return false;
        }
        source = sourceAndTarget.get(0);
        Edge edge = source.getOutgoing(type, target = sourceAndTarget.get(1));
        return edge == null;
    }

    private List<Node> getSourceAndTargetForEdgeCreation(Node source, Node target, boolean reverse) {
        Graph sourceGraph = source.getGraph();
        Graph targetGraph = target.getGraph();
        if (sourceGraph == null || targetGraph == null) {
            return null;
        }
        Rule sourceRule = sourceGraph.getRule();
        Rule targetRule = targetGraph.getRule();
        if (sourceRule == null || targetRule == null) {
            return null;
        }
        EList<Rule> multis = this.getAllMultiRules();
        if (sourceRule != this && !multis.contains(sourceRule)) {
            return null;
        }
        if (targetRule != this && !multis.contains(targetRule)) {
            return null;
        }
        List<Object> result = new Vector<Node>();
        if (sourceRule == targetRule) {
            if (sourceGraph == targetGraph) {
                result.add(source);
                result.add(target);
            } else if (sourceGraph.isLhs()) {
                Node sourceImage;
                MappingList mappings = null;
                if (targetGraph.isRhs()) {
                    mappings = targetRule.getMappings();
                } else if (targetGraph.isNestedCondition()) {
                    mappings = ((NestedCondition)targetGraph.eContainer()).getMappings();
                }
                if (mappings != null && (sourceImage = mappings.getImage(source, targetGraph)) != null) {
                    result.add(sourceImage);
                    result.add(target);
                }
            } else if (targetGraph.isLhs()) {
                result = this.getSourceAndTargetForEdgeCreation(target, source, true);
            }
        } else {
            EList<Rule> path = sourceRule.getMultiRulePath(targetRule);
            if (!path.isEmpty()) {
                Node newSource = source;
                for (Rule multiRule : path) {
                    newSource = multiRule.getMultiMappings().getImage(newSource, (Graph)null);
                    if (newSource == null) break;
                }
                if (newSource != null) {
                    return this.getSourceAndTargetForEdgeCreation(newSource, target, reverse);
                }
            } else {
                path = targetRule.getMultiRulePath(sourceRule);
                if (!path.isEmpty()) {
                    result = this.getSourceAndTargetForEdgeCreation(target, source, true);
                }
            }
        }
        if (reverse) {
            Collections.reverse(result);
        }
        return result.isEmpty() ? null : result;
    }

    @Override
    public boolean removeEdge(Edge edge, boolean removeMapped) {
        if (this.getRootRule() != this) {
            return this.getRootRule().removeEdge(edge, removeMapped);
        }
        HashSet<Edge> edges = new HashSet<Edge>();
        edges.add(edge);
        if (removeMapped) {
            boolean changed;
            MappingList mappings = this.getAllMappings();
            do {
                changed = false;
                TreeIterator it = this.eAllContents();
                while (it.hasNext()) {
                    Edge e;
                    EObject obj = (EObject)it.next();
                    if (!(obj instanceof Edge) || (e = (Edge)obj).getType() != edge.getType() || edges.contains(e) || (mappings.get(edge.getSource(), e.getSource()) == null || mappings.get(edge.getTarget(), e.getTarget()) == null) && (mappings.get(e.getSource(), edge.getSource()) == null || mappings.get(e.getTarget(), edge.getTarget()) == null)) continue;
                    edges.add(e);
                    changed = true;
                }
            } while (changed);
        }
        for (Edge e : edges) {
            e.getGraph().removeEdge(e);
        }
        return true;
    }

    @Override
    public boolean removeAttribute(Attribute attribute, boolean removeMapped) {
        if (attribute.getNode() == null) {
            return false;
        }
        if (this.getRootRule() != this) {
            return this.getRootRule().removeAttribute(attribute, removeMapped);
        }
        if (removeMapped && attribute.getType() != null) {
            HashSet<Node> nodes = new HashSet<Node>();
            HashSet<Mapping> mappings = new HashSet<Mapping>();
            nodes.add(attribute.getNode());
            this.getNodeMappings(nodes, mappings, true);
            for (Node n : nodes) {
                Attribute a = n.getAttribute(attribute.getType());
                if (a == null) continue;
                n.getAttributes().remove((Object)a);
            }
        } else {
            attribute.setNode(null);
        }
        return true;
    }

    @Override
    public boolean isCheckDangling() {
        return this.checkDangling;
    }

    @Override
    public void setCheckDangling(boolean newCheckDangling) {
        boolean oldCheckDangling = this.checkDangling;
        this.checkDangling = newCheckDangling;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldCheckDangling, this.checkDangling));
        }
    }

    @Override
    public boolean isInjectiveMatching() {
        return this.injectiveMatching;
    }

    @Override
    public void setInjectiveMatching(boolean newInjectiveMatching) {
        boolean oldInjectiveMatching = this.injectiveMatching;
        this.injectiveMatching = newInjectiveMatching;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldInjectiveMatching, this.injectiveMatching));
        }
    }

    @Override
    public EList<Rule> getMultiRules() {
        if (this.multiRules == null) {
            this.multiRules = new EObjectContainmentEList(Rule.class, (InternalEObject)this, 11);
        }
        return this.multiRules;
    }

    @Override
    public MappingList getMultiMappings() {
        if (this.multiMappings == null) {
            this.multiMappings = new MappingContainmentListImpl((InternalEObject)this, 12);
        }
        return (MappingList)this.multiMappings;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getAttributeConditions()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return this.basicSetLhs(null, msgs);
            }
            case 6: {
                return this.basicSetRhs(null, msgs);
            }
            case 7: {
                return ((InternalEList)this.getAttributeConditions()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getMappings()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getMultiRules()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getMultiMappings()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getLhs();
            }
            case 6: {
                return this.getRhs();
            }
            case 7: {
                return this.getAttributeConditions();
            }
            case 8: {
                return this.getMappings();
            }
            case 9: {
                return this.isCheckDangling();
            }
            case 10: {
                return this.isInjectiveMatching();
            }
            case 11: {
                return this.getMultiRules();
            }
            case 12: {
                return this.getMultiMappings();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setLhs((Graph)newValue);
                return;
            }
            case 6: {
                this.setRhs((Graph)newValue);
                return;
            }
            case 7: {
                this.getAttributeConditions().clear();
                this.getAttributeConditions().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getMappings().clear();
                this.getMappings().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setCheckDangling((Boolean)newValue);
                return;
            }
            case 10: {
                this.setInjectiveMatching((Boolean)newValue);
                return;
            }
            case 11: {
                this.getMultiRules().clear();
                this.getMultiRules().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getMultiMappings().clear();
                this.getMultiMappings().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setLhs(null);
                return;
            }
            case 6: {
                this.setRhs(null);
                return;
            }
            case 7: {
                this.getAttributeConditions().clear();
                return;
            }
            case 8: {
                this.getMappings().clear();
                return;
            }
            case 9: {
                this.setCheckDangling(true);
                return;
            }
            case 10: {
                this.setInjectiveMatching(true);
                return;
            }
            case 11: {
                this.getMultiRules().clear();
                return;
            }
            case 12: {
                this.getMultiMappings().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.lhs != null;
            }
            case 6: {
                return this.rhs != null;
            }
            case 7: {
                return this.attributeConditions != null && !this.attributeConditions.isEmpty();
            }
            case 8: {
                return this.mappings != null && !this.mappings.isEmpty();
            }
            case 9: {
                return !this.checkDangling;
            }
            case 10: {
                return !this.injectiveMatching;
            }
            case 11: {
                return this.multiRules != null && !this.multiRules.isEmpty();
            }
            case 12: {
                return this.multiMappings != null && !this.multiMappings.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public EList<Unit> getSubUnits() {
        return ECollections.EMPTY_ELIST;
    }
}

