/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.policies;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeEditPart;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class ActionLabelDirectEditPolicy
extends LabelDirectEditPolicy {
    protected Command getDirectEditCommand(DirectEditRequest request) {
        Command command = super.getDirectEditCommand(request);
        if (command == null) {
            return null;
        }
        CompoundCommand result = new CompoundCommand();
        result.add(command);
        IGraphicalEditPart host = (IGraphicalEditPart)this.getHost();
        result.add((Command)new ICommandProxy((ICommand)new UpdateViewsCommand(host.getEditingDomain(), null)));
        return result;
    }

    private class UpdateViewsCommand
    extends AbstractTransactionalCommand {
        public UpdateViewsCommand(TransactionalEditingDomain domain, List<?> affectedFiles) {
            super(domain, "Update Views", affectedFiles);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            EditPart editpart = ActionLabelDirectEditPolicy.this.getHost();
            while (editpart != null) {
                editpart.refresh();
                EditPolicy policy = editpart.getEditPolicy((Object)"Canonical");
                if (policy instanceof CanonicalEditPolicy) {
                    ((CanonicalEditPolicy)policy).refresh();
                }
                if (editpart instanceof NodeEditPart) {
                    for (Object con : ((NodeEditPart)editpart).getSourceConnections()) {
                        this.updateConnection((ConnectionEditPart)con);
                    }
                    for (Object con : ((NodeEditPart)editpart).getTargetConnections()) {
                        this.updateConnection((ConnectionEditPart)con);
                    }
                }
                if (editpart instanceof ConnectionEditPart) {
                    this.updateConnection((ConnectionEditPart)editpart);
                }
                editpart = editpart.getParent();
            }
            return CommandResult.newOKCommandResult();
        }

        private void updateConnection(ConnectionEditPart connection) {
            if (connection.getSource() != null) {
                connection.getSource().refresh();
            }
            if (connection.getTarget() != null) {
                connection.getTarget().refresh();
            }
            for (Object child : connection.getChildren()) {
                if (!(child instanceof LabelEditPart)) continue;
                ((LabelEditPart)child).refresh();
            }
        }
    }
}

