/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.gossipinggirls;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.Path;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.StateValidator;
import org.eclipse.emf.henshin.statespace.impl.ParallelStateSpaceManager;
import org.eclipse.emf.henshin.statespace.impl.ShortestPathStateSpaceValidator;
import org.eclipse.emf.henshin.statespace.ocl.OCLStateValidator;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResourceSet;
import org.eclipse.emf.henshin.statespace.util.StateSpaceExplorationHelper;

public class GossipingGirls {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/gossipinggirls";

    public static void run(String path, int maxGirls) {
        block7: {
            System.out.println("Generating state spaces for gossiping girls...");
            System.out.println("MaxMemory: " + Runtime.getRuntime().maxMemory() / 0x100000L + "MB\n");
            StateSpaceResourceSet resourceSet = new StateSpaceResourceSet(path);
            StateSpace stateSpace = resourceSet.getStateSpace("2-girls.henshin_statespace");
            ParallelStateSpaceManager manager = new ParallelStateSpaceManager(stateSpace);
            Rule addGirlRule = (Rule)((Rule)stateSpace.getRules().get(0)).getModule().getUnit("addGirl");
            EngineImpl engine = new EngineImpl();
            try {
                try {
                    System.out.println("Girls\tStates\tTrans\tCalls\tGenTime\tChkTime");
                    int girls = 2;
                    while (girls <= maxGirls) {
                        manager.resetStateSpace(false);
                        long genTime = System.currentTimeMillis();
                        new StateSpaceExplorationHelper((StateSpaceManager)manager).doExploration(-1, (IProgressMonitor)new NullProgressMonitor());
                        genTime = System.currentTimeMillis() - genTime;
                        ShortestPathStateSpaceValidator validator = new ShortestPathStateSpaceValidator((StateValidator)new OCLStateValidator());
                        validator.setStateSpaceIndex((StateSpaceIndex)manager);
                        validator.setProperty("girls->forAll(g : Girl | g.secrets->size()=girls->size())");
                        long chkTime = System.currentTimeMillis();
                        Path shortest = (Path)validator.validate(manager.getStateSpace(), (IProgressMonitor)new NullProgressMonitor()).getResult();
                        chkTime = System.currentTimeMillis() - chkTime;
                        System.out.println(String.valueOf(girls) + "\t" + stateSpace.getStateCount() + "\t" + stateSpace.getTransitionCount() + "\t" + shortest.size() + "\t" + genTime + "\t" + chkTime);
                        EGraph initialStateGraph = manager.getModel((State)stateSpace.getInitialStates().get(0)).getEGraph();
                        RuleApplicationImpl app = new RuleApplicationImpl((Engine)engine);
                        app.setEGraph(initialStateGraph);
                        app.setRule(addGirlRule);
                        if (!app.execute(null)) {
                            throw new RuntimeException("Error adding girl!");
                        }
                        ++girls;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    manager.shutdown();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                manager.shutdown();
                throw throwable;
            }
            manager.shutdown();
        }
        System.out.println();
    }

    public static void main(String[] args) {
        System.out.println("\n*** WARMUP PHASE ***\n");
        GossipingGirls.run(PATH, 4);
        System.out.println("\n*** BENCHMARKING ***\n");
        GossipingGirls.run(PATH, 8);
    }
}

