/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.text.ParseException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.diagram.parsers.NodeActionParser;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class AttributeParser
extends AbstractParser {
    public AttributeParser() {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
    }

    public String getEditString(IAdaptable element, int flags) {
        Rule rule;
        Attribute image;
        if (!(element.getAdapter(EObject.class) instanceof Attribute)) {
            return "?";
        }
        Attribute attribute = (Attribute)element.getAdapter(EObject.class);
        String type = attribute.getType() != null ? attribute.getType().getName() : null;
        String result = String.valueOf(type) + "=" + attribute.getValue();
        if (attribute.getNode() == null || attribute.getNode().getGraph() == null || attribute.getNode().getGraph().getRule() == null) {
            return result;
        }
        Action action = attribute.getAction();
        Node actionNode = attribute.getNode().getActionNode();
        Action nodeAction = actionNode.getAction();
        if (action != null && !action.equals((Object)nodeAction)) {
            result = String.valueOf(NodeActionParser.addActionQuotes(action.toString())) + " " + result;
        }
        if (nodeAction.getType() == Action.Type.PRESERVE && (image = (rule = attribute.getNode().getGraph().getRule()).getMappings().getImage(attribute, rule.getRhs())) != null && !String.valueOf(attribute.getValue()).equals(String.valueOf(image.getValue()))) {
            result = String.valueOf(result) + "->" + image.getValue();
        }
        return result;
    }

    public String getPrintString(IAdaptable element, int flags) {
        return this.getEditString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final Attribute attribute = (Attribute)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)attribute);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Parse Attribute", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return AttributeParser.this.doParsing(value, attribute);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value, Attribute attribute) {
        Rule rule;
        Attribute image;
        int equalSign;
        Node actionNode;
        Action nodeAction;
        Action.Type nodeActionType;
        boolean compatible;
        int end;
        Node node = attribute.getNode();
        if (node == null || node.getType() == null) {
            return CommandResult.newErrorCommandResult((String)"Node and node type must be set");
        }
        if (node.getGraph() == null || node.getGraph().getRule() == null) {
            return CommandResult.newErrorCommandResult((String)"Node is not properly contained in a graph/rule");
        }
        value = value.trim();
        String actionString = null;
        if (value.startsWith("<<")) {
            value = value.substring(2);
            end = value.indexOf(">>");
            actionString = value.substring(0, end);
            value = value.substring(end + 2);
        } else if (value.startsWith("\u00ab")) {
            value = value.substring(1);
            end = value.indexOf("\u00bb");
            actionString = value.substring(0, end);
            value = value.substring(end + 1);
        }
        Action action = new Action(Action.Type.PRESERVE);
        if (actionString != null) {
            try {
                action = Action.parse((String)actionString);
            }
            catch (ParseException e) {
                return CommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        boolean bl = compatible = (nodeActionType = (nodeAction = (actionNode = node.getActionNode()).getAction()).getType()) == Action.Type.PRESERVE || nodeActionType == Action.Type.DELETE && (action.getType() == Action.Type.FORBID || action.getType() == Action.Type.REQUIRE);
        if (!compatible) {
            action = nodeAction;
        }
        if ((equalSign = value.indexOf(61)) < 0) {
            return CommandResult.newErrorCommandResult((String)"Expected '='");
        }
        String type = value.substring(0, equalSign).trim();
        String val = value.substring(equalSign + 1).trim();
        String newVal = null;
        int arrow = val.indexOf("->");
        if (arrow >= 0) {
            newVal = val.substring(arrow + 2).trim();
            val = val.substring(0, arrow).trim();
        }
        EAttribute attr = null;
        for (EAttribute current : node.getType().getEAllAttributes()) {
            if (!type.equals(current.getName())) continue;
            attr = current;
            break;
        }
        if (attr == null) {
            return CommandResult.newErrorCommandResult((String)("Unknown attribute: " + type));
        }
        if (action.getType() == Action.Type.PRESERVE && (image = (rule = node.getGraph().getRule()).getMappings().getImage(attribute, rule.getRhs())) != null) {
            image.setValue(newVal != null && newVal.length() > 0 ? newVal : val);
            image.setType(attr);
        }
        attribute.setValue("?");
        attribute.setValue(val);
        attribute.setType(attr);
        Action currentAction = attribute.getAction();
        if (currentAction != null && !currentAction.equals((Object)action)) {
            try {
                attribute.setAction(action);
            }
            catch (Throwable t) {
                HenshinDiagramEditorPlugin.getInstance().logError("Error setting attribute action", t);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getAttribute_Value()) {
            return true;
        }
        return feature == HenshinPackage.eINSTANCE.getAttribute_Type();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

