/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.jobs;

import java.text.DecimalFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.commands.ExploreStatesCommand;
import org.eclipse.emf.henshin.statespace.explorer.jobs.AbstractStateSpaceJob;
import org.eclipse.emf.henshin.statespace.util.StateSpaceExplorationHelper;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;

public class ExploreStateSpaceJob
extends AbstractStateSpaceJob {
    private final StateSpaceExplorationHelper helper;
    protected final EditDomain editDomain;
    private int cleanupInterval = 1800;
    private int saveInterval = 1800;
    protected boolean logInfo = true;

    public ExploreStateSpaceJob(StateSpaceManager manager, EditDomain editDomain) {
        super("Exploring state space...", manager);
        this.editDomain = editDomain;
        this.helper = new StateSpaceExplorationHelper(manager);
        this.helper.setStepDuration(800);
        this.helper.setGenerateLocations(false);
        this.setUser(true);
        this.setPriority(30);
    }

    protected IStatus run(IProgressMonitor monitor) {
        long start;
        monitor.beginTask("Exploring state space...", -1);
        StateSpaceManager manager = this.getStateSpaceManager();
        StateSpace stateSpace = manager.getStateSpace();
        DecimalFormat largeFormat = new DecimalFormat("#,###,###,##0");
        DecimalFormat speedFormat = new DecimalFormat("###,##0.0");
        long lastSave = start = System.currentTimeMillis();
        long lastCleanup = start;
        int initialClosedStateCount = stateSpace.getStates().size() - stateSpace.getOpenStates().size();
        boolean moreStates = true;
        try {
            while (moreStates && !monitor.isCanceled()) {
                ExploreStatesCommand command = new ExploreStatesCommand(this.helper);
                command.setCallingJob(this);
                this.executeExploreCommand(command, monitor);
                moreStates = command.getResult();
                int states = stateSpace.getStates().size();
                double speed = this.helper.getCurrentSpeed();
                monitor.subTask(String.valueOf(largeFormat.format(states)) + " states (" + largeFormat.format(stateSpace.getOpenStates().size()) + " open), " + largeFormat.format(stateSpace.getTransitionCount()) + " transitions. Exploring " + speedFormat.format(speed) + " states/second...");
                if (!monitor.isCanceled()) {
                    long current = System.currentTimeMillis();
                    if (this.cleanupInterval >= 0 && current > lastCleanup + (long)(this.cleanupInterval * 1000)) {
                        this.clearCache(monitor);
                        lastCleanup = System.currentTimeMillis();
                    }
                    if (this.saveInterval < 0 || current <= lastSave + (long)(this.saveInterval * 1000)) continue;
                    monitor.subTask("Saving state space...");
                    this.saveStateSpace();
                    lastSave = System.currentTimeMillis();
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            return new Status(4, "org.eclipse.emf.henshin.statespace.explorer", 0, "Error exploring state space", e);
        }
        long end = System.currentTimeMillis();
        this.clearCache(monitor);
        if (this.saveInterval >= 0 && !this.isAborted()) {
            monitor.subTask("Saving state space...");
            this.saveStateSpace();
        }
        if (this.logInfo && !this.isAborted()) {
            int finalClosedStateCount = stateSpace.getStates().size() - stateSpace.getOpenStates().size();
            int explored = finalClosedStateCount - initialClosedStateCount;
            String statesPerSec = "";
            if (end > start) {
                statesPerSec = " (" + speedFormat.format((double)(1000 * explored) / (double)(end - start)) + " states/second)";
            }
            StateSpaceExplorerPlugin.getInstance().logInfo("Explored " + explored + " states in " + (end - start) / 1000L + " seconds" + statesPerSec);
        }
        return new Status(0, "org.eclipse.emf.henshin.statespace.explorer", 0, null, null);
    }

    private void clearCache(IProgressMonitor monitor) {
        monitor.subTask("Clearing state model cache...");
        this.getStateSpaceManager().clearCache();
    }

    protected void executeExploreCommand(Command command, IProgressMonitor monitor) {
        this.editDomain.getCommandStack().execute(command);
    }

    public void setSaveInterval(int seconds) {
        this.saveInterval = seconds;
    }

    public void setCleanupInterval(int seconds) {
        this.cleanupInterval = seconds;
    }

    public StateSpaceExplorationHelper getExplorationHelper() {
        return this.helper;
    }
}

