/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.edit;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.commands.ExploreStatesCommand;
import org.eclipse.emf.henshin.statespace.explorer.edit.StateComponentEditPolicy;
import org.eclipse.emf.henshin.statespace.explorer.edit.StateSpaceEditPart;
import org.eclipse.emf.henshin.statespace.explorer.edit.TransitionEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Color;

public class StateEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
Adapter {
    public static final int SIZE = 18;
    public static final Color COLOR_DEFAULT = StateEditPart.RGB2Color(State.COLOR_DEFAULT);
    public static final Color COLOR_INITIAL = StateEditPart.RGB2Color(State.COLOR_INITIAL);
    public static final Color COLOR_TERMINAL = StateEditPart.RGB2Color(State.COLOR_TERMINAL);
    public static final Color COLOR_OPEN = StateEditPart.RGB2Color(State.COLOR_OPEN);
    private ConnectionAnchor anchor;
    private Notifier target;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getState().eAdapters().add((Object)this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new StateComponentEditPolicy());
    }

    protected IFigure createFigure() {
        return new StateFigure();
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getState().eAdapters().remove((Object)this);
            super.deactivate();
        }
    }

    public State getState() {
        return (State)this.getModel();
    }

    public StateSpaceManager getStateSpaceManager() {
        return ((StateSpaceEditPart)this.getParent()).getStateSpaceManager();
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            this.anchor = new EllipseAnchor(this.getFigure());
        }
        return this.anchor;
    }

    protected List<?> getModelSourceConnections() {
        return this.getState().getOutgoing();
    }

    protected List<?> getModelTargetConnections() {
        return this.getState().getIncoming();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    protected void refreshVisuals() {
        this.refreshLabelAndLocation(this.getState().getStateSpace().isLayoutHideLabels());
        this.refreshColor();
    }

    public void refreshLabelAndLocation(boolean hideLabel) {
        StateFigure figure = (StateFigure)this.getFigure();
        figure.setHideLabel(hideLabel);
        if (!hideLabel) {
            figure.getLabel().setText(" " + this.getState().getIndex() + " ");
        }
        for (Object edge : this.getSourceConnections()) {
            if (!(edge instanceof TransitionEditPart)) continue;
            ((TransitionEditPart)((Object)edge)).refreshLabel(hideLabel);
        }
        if (this.getState().isInitial()) {
            URI modelURI = this.getState().getModel().getResource().getURI();
            String tooltip = modelURI.deresolve(this.getState().eResource().getURI()).toString();
            this.getFigure().setToolTip((IFigure)new Label(tooltip));
        }
        int[] loc = this.getState().getLocation();
        int w = hideLabel || this.getState().getIndex() < 10 ? 18 : -1;
        Rectangle bounds = new Rectangle(loc[0], loc[1], w, 18);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)figure, (Object)bounds);
    }

    private void refreshColor() {
        State state = this.getState();
        if (state.isInitial()) {
            this.getFigure().setBackgroundColor(COLOR_INITIAL);
        } else if (state.isTerminal()) {
            this.getFigure().setBackgroundColor(COLOR_TERMINAL);
        } else if (state.isOpen()) {
            this.getFigure().setBackgroundColor(COLOR_OPEN);
        } else {
            this.getFigure().setBackgroundColor(COLOR_DEFAULT);
        }
    }

    private static Color RGB2Color(int[] rgb) {
        return new Color(null, rgb[0], rgb[1], rgb[2]);
    }

    public void performRequest(Request request) {
        if (request.getType() == "open" && this.getState().isOpen()) {
            ExploreStatesCommand command = new ExploreStatesCommand(this.getStateSpaceManager(), Collections.singletonList(this.getState()), true);
            CommandStack stack = this.getViewer().getEditDomain().getCommandStack();
            stack.execute((Command)command);
        } else {
            super.performRequest(request);
        }
    }

    public Notifier getTarget() {
        return this.target;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification event) {
        switch (event.getFeatureID(State.class)) {
            case 0: {
                this.refreshColor();
                this.refreshLabelAndLocation(this.getState().getStateSpace().isLayoutHideLabels());
                break;
            }
            case 1: {
                this.refreshLabelAndLocation(this.getState().getStateSpace().isLayoutHideLabels());
                break;
            }
            case 3: {
                this.refreshSourceConnections();
                break;
            }
            case 2: {
                this.refreshTargetConnections();
            }
        }
    }

    public void setTarget(Notifier target) {
        this.target = target;
    }

    static class StateFigure
    extends Ellipse {
        private Label label;

        StateFigure() {
            this.setAntialias(1);
            this.setOpaque(true);
            this.setLayoutManager((LayoutManager)new StackLayout());
        }

        public Label getLabel() {
            return this.label;
        }

        public void setHideLabel(boolean hideLabel) {
            if (hideLabel && this.label != null) {
                this.remove((IFigure)this.label);
                this.label = null;
            } else if (!hideLabel && this.label == null) {
                this.label = new Label(){

                    public String getSubStringText() {
                        return this.getText();
                    }
                };
                this.add((IFigure)this.label);
            }
        }
    }
}

