/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.external.AbstractFileBasedValidator;
import org.eclipse.emf.henshin.statespace.external.prism.CTMCStateSpaceExporter;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMExperiment;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMUtil;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;

public class CTMCStateSpaceValidator
extends AbstractFileBasedValidator {
    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Checking CSL property...", 4);
        CTMCStateSpaceExporter exporter = new CTMCStateSpaceExporter();
        File modelFile = this.export(stateSpace, exporter, null, "sm", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        String expanded = PRISMUtil.expandLabels(this.property, this.index, exporter.getTuples(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        File cslFile = this.createTempFile("property", ".csl", expanded);
        monitor.subTask("Running PRISM...");
        Map<String, String> constants = PRISMUtil.getAllRates(stateSpace, true);
        Process process = PRISMUtil.invokePRISM(stateSpace, modelFile, cslFile, null, constants, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return PRISMExperiment.parseValidationResult(stateSpace, process, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    public String getName() {
        return "PRISM CTMC";
    }

    public boolean usesProperty() {
        return true;
    }
}

