/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.resource;

import java.io.File;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.resource.HenshinResourceFactory;

public class HenshinResourceSet
extends ResourceSetImpl {
    private URI baseDir;

    public HenshinResourceSet(String baseDir) {
        EcorePackage.eINSTANCE.getName();
        HenshinPackage.eINSTANCE.getName();
        this.registerXMIResourceFactories("henshin", "ecore", "xmi");
        if (baseDir != null) {
            if (!(baseDir = new File(baseDir).getAbsolutePath()).endsWith(File.separator)) {
                baseDir = String.valueOf(baseDir) + File.separator;
            }
            this.baseDir = URI.createFileURI((String)baseDir);
            this.setURIConverter((URIConverter)new BaseDirURIConverter());
        }
    }

    public HenshinResourceSet() {
        this(null);
    }

    public URI getBaseDir() {
        return this.baseDir;
    }

    public void registerXMIResourceFactories(String ... fileExtensions) {
        Map map = this.getResourceFactoryRegistry().getExtensionToFactoryMap();
        String[] stringArray = fileExtensions;
        int n = fileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            HenshinResourceFactory factory = "henshin".equals(extension) ? new HenshinResourceFactory() : new XMIResourceFactoryImpl();
            if (!map.containsKey(extension)) {
                map.put(extension, factory);
            }
            ++n2;
        }
    }

    public EObject getFirstRoot(String path) {
        return (EObject)this.getResource(URI.createFileURI((String)path), true).getContents().get(0);
    }

    public TransformationSystem getTransformationSystem(String path) {
        return (TransformationSystem)this.getFirstRoot(path);
    }

    private class BaseDirURIConverter
    extends ExtensibleURIConverterImpl {
        private BaseDirURIConverter() {
        }

        public URI normalize(URI uri) {
            if (uri.isFile() && uri.isRelative() && HenshinResourceSet.this.baseDir != null) {
                return uri.resolve(HenshinResourceSet.this.baseDir);
            }
            return super.normalize(uri);
        }
    }
}

