/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions;

import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.emf.henshin.model.actions.ActionType;

public class Action {
    private static final String SEPARATOR_TYPE = ":";
    private static final Pattern PATTERN_TYPE = Pattern.compile(":");
    private static final String SEPARATOR_ARGS = ",";
    private static final Pattern PATTERN_ARGS = Pattern.compile(",");
    private static final String MARKER_AMALGAMATION = "*";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private ActionType type;
    private boolean amalgamated;
    private String[] arguments;

    public static Action parse(String value) throws ParseException {
        String[] typeAndArgs = PATTERN_TYPE.split(value, 2);
        boolean amalgamated = false;
        String trimmedType = typeAndArgs[0].trim();
        if (trimmedType.endsWith(MARKER_AMALGAMATION)) {
            amalgamated = true;
            trimmedType = trimmedType.substring(0, trimmedType.length() - 1);
        }
        ActionType type = ActionType.parse(trimmedType);
        String[] args = typeAndArgs.length == 2 ? PATTERN_ARGS.split(typeAndArgs[1]) : EMPTY_STRING_ARRAY;
        return new Action(type, amalgamated, args);
    }

    public Action(ActionType type, boolean amalgamated, String ... arguments) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter type must not be null.");
        }
        this.type = type;
        this.amalgamated = amalgamated;
        this.arguments = arguments == null ? EMPTY_STRING_ARRAY : arguments;
    }

    public Action(ActionType type, String ... arguments) {
        this(type, false, arguments);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Action) {
            Action action = (Action)object;
            return this.type == action.getType() && this.amalgamated == action.isAmalgamated() && Arrays.equals(this.arguments, action.getArguments());
        }
        return false;
    }

    public boolean isAmalgamated() {
        return this.amalgamated;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public ActionType getType() {
        return this.type;
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        String[] stringArray = this.arguments;
        int n = this.arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            hash = hash + argument.hashCode() << 1;
            ++n2;
        }
        if (this.amalgamated) {
            ++hash;
        }
        return hash;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.type.toString());
        if (this.amalgamated) {
            result.append(MARKER_AMALGAMATION);
        }
        if (this.arguments.length > 0) {
            result.append(SEPARATOR_TYPE);
            result.append(this.arguments[0]);
            int i = 1;
            while (i < this.arguments.length) {
                result.append(SEPARATOR_ARGS);
                result.append(this.arguments[i]);
                ++i;
            }
        }
        return result.toString();
    }
}

